/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.storage.SideInputsProcessor;

@InterfaceStability.Unstable
public class TableSpec
implements Serializable {
    private final String id;
    private final String tableProviderFactoryClassName;
    private final transient KVSerde serde;
    private final transient List<String> sideInputs;
    private final transient SideInputsProcessor sideInputsProcessor;
    private final transient Map<String, String> config = new HashMap<String, String>();

    public TableSpec() {
        this.id = null;
        this.serde = null;
        this.tableProviderFactoryClassName = null;
        this.sideInputs = null;
        this.sideInputsProcessor = null;
    }

    public TableSpec(String tableId, KVSerde serde, String tableProviderFactoryClassName, Map<String, String> config) {
        this(tableId, serde, tableProviderFactoryClassName, config, Collections.emptyList(), null);
    }

    public TableSpec(String tableId, KVSerde serde, String tableProviderFactoryClassName, Map<String, String> config, List<String> sideInputs, SideInputsProcessor sideInputsProcessor) {
        this.id = tableId;
        this.serde = serde;
        this.tableProviderFactoryClassName = tableProviderFactoryClassName;
        this.config.putAll(config);
        this.sideInputs = sideInputs;
        this.sideInputsProcessor = sideInputsProcessor;
    }

    public String getId() {
        return this.id;
    }

    public <K, V> KVSerde<K, V> getSerde() {
        return this.serde;
    }

    public String getTableProviderFactoryClassName() {
        return this.tableProviderFactoryClassName;
    }

    public Map<String, String> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public List<String> getSideInputs() {
        return this.sideInputs;
    }

    public SideInputsProcessor getSideInputsProcessor() {
        return this.sideInputsProcessor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.id.equals(((TableSpec)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

