/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.descriptors;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.descriptors.InputTransformer;
import org.apache.samza.system.descriptors.StreamExpander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SystemDescriptor<SubClass extends SystemDescriptor<SubClass>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemDescriptor.class);
    private static final String FACTORY_CONFIG_KEY = "systems.%s.samza.factory";
    private static final String DEFAULT_STREAM_OFFSET_DEFAULT_CONFIG_KEY = "systems.%s.default.stream.samza.offset.default";
    private static final String DEFAULT_STREAM_CONFIGS_CONFIG_KEY = "systems.%s.default.stream.%s";
    private static final String SYSTEM_CONFIGS_CONFIG_KEY = "systems.%s.%s";
    private static final Pattern SYSTEM_NAME_PATTERN = Pattern.compile("[\\d\\w-_]+");
    private final String systemName;
    private final Optional<String> factoryClassNameOptional;
    private final Optional<InputTransformer> transformerOptional;
    private final Optional<StreamExpander> expanderOptional;
    private final Map<String, String> systemConfigs = new HashMap<String, String>();
    private final Map<String, String> defaultStreamConfigs = new HashMap<String, String>();
    private Optional<SystemStreamMetadata.OffsetType> defaultStreamOffsetDefaultOptional = Optional.empty();

    public SystemDescriptor(String systemName, String factoryClassName, InputTransformer transformer, StreamExpander expander) {
        Preconditions.checkArgument((boolean)this.isValidSystemName(systemName), (Object)String.format("systemName: %s must be non-empty and must not contain spaces or special characters.", systemName));
        if (StringUtils.isBlank((CharSequence)factoryClassName)) {
            LOGGER.warn("Blank SystemFactory class name for system: {}. A value must be provided in configuration using {}.", (Object)systemName, (Object)String.format(FACTORY_CONFIG_KEY, systemName));
        }
        this.systemName = systemName;
        this.factoryClassNameOptional = Optional.ofNullable(StringUtils.stripToNull((String)factoryClassName));
        this.transformerOptional = Optional.ofNullable(transformer);
        this.expanderOptional = Optional.ofNullable(expander);
    }

    public SubClass withDefaultStreamOffsetDefault(SystemStreamMetadata.OffsetType offsetType) {
        this.defaultStreamOffsetDefaultOptional = Optional.ofNullable(offsetType);
        return (SubClass)this;
    }

    public SubClass withSystemConfigs(Map<String, String> systemConfigs) {
        this.systemConfigs.putAll(systemConfigs);
        return (SubClass)this;
    }

    public SubClass withDefaultStreamConfigs(Map<String, String> defaultStreamConfigs) {
        this.defaultStreamConfigs.putAll(defaultStreamConfigs);
        return (SubClass)this;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public Optional<InputTransformer> getTransformer() {
        return this.transformerOptional;
    }

    public Optional<StreamExpander> getExpander() {
        return this.expanderOptional;
    }

    private boolean isValidSystemName(String id) {
        return StringUtils.isNotBlank((CharSequence)id) && SYSTEM_NAME_PATTERN.matcher(id).matches();
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        this.factoryClassNameOptional.ifPresent(name -> configs.put(String.format(FACTORY_CONFIG_KEY, this.systemName), (String)name));
        this.defaultStreamOffsetDefaultOptional.ifPresent(dsod -> configs.put(String.format(DEFAULT_STREAM_OFFSET_DEFAULT_CONFIG_KEY, this.systemName), dsod.name().toLowerCase()));
        this.defaultStreamConfigs.forEach((key, value) -> configs.put(String.format(DEFAULT_STREAM_CONFIGS_CONFIG_KEY, this.getSystemName(), key), (String)value));
        this.systemConfigs.forEach((key, value) -> configs.put(String.format(SYSTEM_CONFIGS_CONFIG_KEY, this.getSystemName(), key), (String)value));
        return configs;
    }
}

