/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.system.SystemStream;

public class StreamSpec
implements Serializable {
    private static final int DEFAULT_PARTITION_COUNT = 1;
    private static final String CHANGELOG_STREAM_ID = "samza-internal-changelog-stream-id";
    private static final String COORDINATOR_STREAM_ID = "samza-internal-coordinator-stream-id";
    private static final String CHECKPOINT_STREAM_ID = "samza-internal-checkpoint-stream-id";
    private static final String STREAM_APPENDER_ID = "samza-internal-stream-appender-stream-id";
    private final String id;
    private final String systemName;
    private final String physicalName;
    private final int partitionCount;
    private final Map<String, String> config;

    public StreamSpec(String id, String physicalName, String systemName) {
        this(id, physicalName, systemName, 1, Collections.emptyMap());
    }

    public StreamSpec(String id, String physicalName, String systemName, int partitionCount) {
        this(id, physicalName, systemName, partitionCount, Collections.emptyMap());
    }

    public StreamSpec(String id, String physicalName, String systemName, Map<String, String> config) {
        this(id, physicalName, systemName, 1, config);
    }

    public StreamSpec(String id, String physicalName, String systemName, int partitionCount, Map<String, String> config) {
        this.validateLogicalIdentifier("streamId", id);
        this.validateLogicalIdentifier("systemName", systemName);
        if (partitionCount < 0) {
            throw new IllegalArgumentException("Parameter 'partitionCount' must be >= 0");
        }
        this.id = id;
        this.systemName = systemName;
        this.physicalName = physicalName;
        this.partitionCount = partitionCount;
        this.config = config != null ? Collections.unmodifiableMap(new HashMap<String, String>(config)) : Collections.emptyMap();
    }

    public StreamSpec copyWithPartitionCount(int partitionCount) {
        return new StreamSpec(this.id, this.physicalName, this.systemName, partitionCount, this.config);
    }

    public StreamSpec copyWithPhysicalName(String physicalName) {
        return new StreamSpec(this.id, physicalName, this.systemName, this.partitionCount, this.config);
    }

    public String getId() {
        return this.id;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public String get(String propertyName) {
        return this.config.get(propertyName);
    }

    public String getOrDefault(String propertyName, String defaultValue) {
        return this.config.getOrDefault(propertyName, defaultValue);
    }

    public SystemStream toSystemStream() {
        return new SystemStream(this.systemName, this.physicalName);
    }

    public boolean isChangeLogStream() {
        return this.id.equals(CHANGELOG_STREAM_ID);
    }

    public boolean isCoordinatorStream() {
        return this.id.equals(COORDINATOR_STREAM_ID);
    }

    private void validateLogicalIdentifier(String identifierName, String identifierValue) {
        if (identifierValue == null || !identifierValue.matches("[A-Za-z0-9_-]+")) {
            throw new IllegalArgumentException(String.format("Identifier '%s' is '%s'. It must match the expression [A-Za-z0-9_-]+", identifierName, identifierValue));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        StreamSpec that = (StreamSpec)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static StreamSpec createChangeLogStreamSpec(String physicalName, String systemName, int partitionCount) {
        return new StreamSpec(CHANGELOG_STREAM_ID, physicalName, systemName, partitionCount);
    }

    public static StreamSpec createCoordinatorStreamSpec(String physicalName, String systemName) {
        return new StreamSpec(COORDINATOR_STREAM_ID, physicalName, systemName, 1);
    }

    public static StreamSpec createCheckpointStreamSpec(String physicalName, String systemName) {
        return new StreamSpec(CHECKPOINT_STREAM_ID, physicalName, systemName, 1);
    }

    public static StreamSpec createStreamAppenderStreamSpec(String physicalName, String systemName, int partitionCount) {
        return new StreamSpec(STREAM_APPENDER_ID, physicalName, systemName, partitionCount);
    }

    public String toString() {
        return String.format("StreamSpec: id=%s, systemName=%s, pName=%s, partCount=%d.", this.id, this.systemName, this.physicalName, this.partitionCount);
    }
}

