/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import org.apache.samza.system.SystemStream;

public class OutgoingMessageEnvelope {
    private final SystemStream systemStream;
    private final String keySerializerName;
    private final String messageSerializerName;
    private final Object partitionKey;
    private final Object key;
    private final Object message;

    public OutgoingMessageEnvelope(SystemStream systemStream, String keySerializerName, String messageSerializerName, Object partitionKey, Object key, Object message) {
        this.systemStream = systemStream;
        this.keySerializerName = keySerializerName;
        this.messageSerializerName = messageSerializerName;
        this.partitionKey = partitionKey;
        this.key = key;
        this.message = message;
    }

    public OutgoingMessageEnvelope(SystemStream systemStream, Object partitionKey, Object key, Object message) {
        this(systemStream, null, null, partitionKey, key, message);
    }

    public OutgoingMessageEnvelope(SystemStream systemStream, Object key, Object message) {
        this(systemStream, null, null, key, key, message);
    }

    public OutgoingMessageEnvelope(SystemStream systemStream, Object message) {
        this(systemStream, null, null, null, null, message);
    }

    public SystemStream getSystemStream() {
        return this.systemStream;
    }

    public String getKeySerializerName() {
        return this.keySerializerName;
    }

    public String getMessageSerializerName() {
        return this.messageSerializerName;
    }

    public Object getPartitionKey() {
        return this.partitionKey;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getMessage() {
        return this.message;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.keySerializerName == null ? 0 : this.keySerializerName.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.messageSerializerName == null ? 0 : this.messageSerializerName.hashCode());
        result = 31 * result + (this.partitionKey == null ? 0 : this.partitionKey.hashCode());
        result = 31 * result + (this.systemStream == null ? 0 : this.systemStream.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutgoingMessageEnvelope other = (OutgoingMessageEnvelope)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.keySerializerName == null ? other.keySerializerName != null : !this.keySerializerName.equals(other.keySerializerName)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.messageSerializerName == null ? other.messageSerializerName != null : !this.messageSerializerName.equals(other.messageSerializerName)) {
            return false;
        }
        if (this.partitionKey == null ? other.partitionKey != null : !this.partitionKey.equals(other.partitionKey)) {
            return false;
        }
        return !(this.systemStream == null ? other.systemStream != null : !this.systemStream.equals(other.systemStream));
    }

    public String toString() {
        return "OutgoingMessageEnvelope [systemStream=" + this.systemStream + ", keySerializerName=" + this.keySerializerName + ", messageSerializerName=" + this.messageSerializerName + ", partitionKey=" + this.partitionKey + ", key=" + this.key + ", message=" + this.message + "]";
    }
}

