/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import java.nio.charset.Charset;
import org.apache.samza.system.EndOfStreamMessage;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.WatermarkMessage;

public class IncomingMessageEnvelope {
    private static final byte[] END_OF_STREAM_BYTES = "\u0000END_OF_STREAM".getBytes();
    public static final String END_OF_STREAM_OFFSET = new String(END_OF_STREAM_BYTES, Charset.defaultCharset());
    private final SystemStreamPartition systemStreamPartition;
    private final String offset;
    private final Object key;
    private final Object message;
    private final int size;
    private long timestamp = 0L;

    public IncomingMessageEnvelope(SystemStreamPartition systemStreamPartition, String offset, Object key, Object message) {
        this(systemStreamPartition, offset, key, message, 0);
    }

    public IncomingMessageEnvelope(SystemStreamPartition systemStreamPartition, String offset, Object key, Object message, int size) {
        this.systemStreamPartition = systemStreamPartition;
        this.offset = offset;
        this.key = key;
        this.message = message;
        this.size = size;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public SystemStreamPartition getSystemStreamPartition() {
        return this.systemStreamPartition;
    }

    public String getOffset() {
        return this.offset;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getMessage() {
        return this.message;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEndOfStream() {
        return END_OF_STREAM_OFFSET.equals(this.offset);
    }

    public static IncomingMessageEnvelope buildEndOfStreamEnvelope(SystemStreamPartition ssp) {
        return new IncomingMessageEnvelope(ssp, END_OF_STREAM_OFFSET, null, new EndOfStreamMessage(null));
    }

    public static IncomingMessageEnvelope buildWatermarkEnvelope(SystemStreamPartition ssp, long watermark) {
        return new IncomingMessageEnvelope(ssp, null, null, new WatermarkMessage(watermark, null));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.systemStreamPartition == null ? 0 : this.systemStreamPartition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncomingMessageEnvelope other = (IncomingMessageEnvelope)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        return !(this.systemStreamPartition == null ? other.systemStreamPartition != null : !this.systemStreamPartition.equals(other.systemStreamPartition));
    }

    public String toString() {
        return "IncomingMessageEnvelope [systemStreamPartition=" + this.systemStreamPartition + ", offset=" + this.offset + ", key=" + this.key + ", message=" + this.message + "]";
    }
}

