/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage;

public class StoreProperties {
    private final boolean persistedToDisk;
    private final boolean loggedStore;

    private StoreProperties(boolean persistedToDisk, boolean loggedStore) {
        this.persistedToDisk = persistedToDisk;
        this.loggedStore = loggedStore;
    }

    public boolean isPersistedToDisk() {
        return this.persistedToDisk;
    }

    public boolean isLoggedStore() {
        return this.loggedStore;
    }

    public static class StorePropertiesBuilder {
        private boolean persistedToDisk = false;
        private boolean loggedStore = false;

        public StorePropertiesBuilder setPersistedToDisk(boolean persistedToDisk) {
            this.persistedToDisk = persistedToDisk;
            return this;
        }

        public StorePropertiesBuilder setLoggedStore(boolean loggedStore) {
            this.loggedStore = loggedStore;
            return this;
        }

        public StoreProperties build() {
            return new StoreProperties(this.persistedToDisk, this.loggedStore);
        }
    }
}

