/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.serializers;

import java.io.UnsupportedEncodingException;
import org.apache.samza.SamzaException;
import org.apache.samza.serializers.Serde;

public class StringSerde
implements Serde<String> {
    private final String encoding;

    public StringSerde(String encoding) {
        this.encoding = encoding;
    }

    public StringSerde() {
        this("UTF-8");
    }

    @Override
    public byte[] toBytes(String obj) {
        if (obj != null) {
            try {
                return obj.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new SamzaException("Unsupported encoding " + this.encoding, e);
            }
        }
        return null;
    }

    @Override
    public String fromBytes(byte[] bytes) {
        if (bytes != null) {
            try {
                return new String(bytes, 0, bytes.length, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new SamzaException("Unsupported encoding " + this.encoding, e);
            }
        }
        return null;
    }
}

