/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.serializers;

import java.nio.ByteBuffer;
import org.apache.samza.operators.KV;
import org.apache.samza.serializers.Serde;

public class KVSerde<K, V>
implements Serde<KV<K, V>> {
    private final Serde<K> keySerde;
    private final Serde<V> valueSerde;

    public KVSerde(Serde<K> keySerde, Serde<V> valueSerde) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
    }

    public static <K, V> KVSerde<K, V> of(Serde<K> keySerde, Serde<V> valueSerde) {
        return new KVSerde<K, V>(keySerde, valueSerde);
    }

    @Override
    public KV<K, V> fromBytes(byte[] bytes) {
        if (bytes != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            int keyLength = byteBuffer.getInt();
            byte[] keyBytes = new byte[keyLength];
            byteBuffer.get(keyBytes);
            int valueLength = byteBuffer.getInt();
            byte[] valueBytes = new byte[valueLength];
            byteBuffer.get(valueBytes);
            Object key = this.keySerde.fromBytes(keyBytes);
            Object value = this.valueSerde.fromBytes(valueBytes);
            return KV.of(key, value);
        }
        return null;
    }

    @Override
    public byte[] toBytes(KV<K, V> obj) {
        if (obj != null) {
            byte[] keyBytes = this.keySerde.toBytes(obj.key);
            byte[] valueBytes = this.valueSerde.toBytes(obj.value);
            byte[] bytes = new byte[8 + keyBytes.length + 8 + valueBytes.length];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.putInt(keyBytes.length);
            byteBuffer.put(keyBytes);
            byteBuffer.putInt(valueBytes.length);
            byteBuffer.put(valueBytes);
            return byteBuffer.array();
        }
        return null;
    }

    public Serde<K> getKeySerde() {
        return this.keySerde;
    }

    public Serde<V> getValueSerde() {
        return this.valueSerde;
    }
}

