/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.serializers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import org.apache.samza.SamzaException;
import org.apache.samza.serializers.Serde;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerdeV2<T>
implements Serde<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerdeV2.class);
    private final Class<T> clazz;
    private transient ObjectMapper mapper = new ObjectMapper();

    public JsonSerdeV2() {
        this(null);
    }

    public JsonSerdeV2(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static <T> JsonSerdeV2<T> of(Class<T> clazz) {
        return new JsonSerdeV2<T>(clazz);
    }

    @Override
    public byte[] toBytes(T obj) {
        if (obj != null) {
            try {
                String str = this.mapper.writeValueAsString(obj);
                return str.getBytes("UTF-8");
            }
            catch (Exception e) {
                throw new SamzaException("Error serializing data.", e);
            }
        }
        return null;
    }

    @Override
    public T fromBytes(byte[] bytes) {
        if (bytes != null) {
            String str;
            try {
                str = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SamzaException("Error deserializing data", e);
            }
            try {
                if (this.clazz != null) {
                    return (T)this.mapper.readValue(str, this.clazz);
                }
                return (T)this.mapper.readValue(str, new TypeReference<T>(){});
            }
            catch (Exception e) {
                LOG.debug("Error deserializing data: " + str, (Throwable)e);
                throw new SamzaException("Error deserializing data", e);
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mapper = new ObjectMapper();
    }
}

