/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.windows;

import java.time.Duration;
import java.util.Collection;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.operators.functions.FoldLeftFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SupplierFunction;
import org.apache.samza.operators.triggers.TimeTrigger;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.triggers.Triggers;
import org.apache.samza.operators.windows.Window;
import org.apache.samza.operators.windows.internal.WindowInternal;
import org.apache.samza.operators.windows.internal.WindowType;
import org.apache.samza.serializers.Serde;

@InterfaceStability.Unstable
public final class Windows {
    private Windows() {
    }

    public static <M, K, WV> Window<M, K, WV> keyedTumblingWindow(MapFunction<? super M, ? extends K> keyFn, Duration interval, SupplierFunction<? extends WV> initialValue, FoldLeftFunction<? super M, WV> aggregator, Serde<K> keySerde, Serde<WV> windowValueSerde) {
        TimeTrigger defaultTrigger = new TimeTrigger(interval);
        return new WindowInternal<M, K, WV>(defaultTrigger, initialValue, aggregator, keyFn, null, WindowType.TUMBLING, keySerde, windowValueSerde, null);
    }

    public static <M, K> Window<M, K, Collection<M>> keyedTumblingWindow(MapFunction<M, K> keyFn, Duration interval, Serde<K> keySerde, Serde<M> msgSerde) {
        TimeTrigger defaultTrigger = new TimeTrigger(interval);
        return new WindowInternal(defaultTrigger, null, null, keyFn, null, WindowType.TUMBLING, keySerde, null, msgSerde);
    }

    public static <M, WV> Window<M, Void, WV> tumblingWindow(Duration interval, SupplierFunction<? extends WV> initialValue, FoldLeftFunction<? super M, WV> aggregator, Serde<WV> windowValueSerde) {
        TimeTrigger defaultTrigger = new TimeTrigger(interval);
        return new WindowInternal(defaultTrigger, initialValue, aggregator, null, null, WindowType.TUMBLING, null, windowValueSerde, null);
    }

    public static <M> Window<M, Void, Collection<M>> tumblingWindow(Duration duration, Serde<M> msgSerde) {
        TimeTrigger defaultTrigger = new TimeTrigger(duration);
        return new WindowInternal(defaultTrigger, null, null, null, null, WindowType.TUMBLING, null, null, msgSerde);
    }

    public static <M, K, WV> Window<M, K, WV> keyedSessionWindow(MapFunction<? super M, ? extends K> keyFn, Duration sessionGap, SupplierFunction<? extends WV> initialValue, FoldLeftFunction<? super M, WV> aggregator, Serde<K> keySerde, Serde<WV> windowValueSerde) {
        Trigger defaultTrigger = Triggers.timeSinceLastMessage(sessionGap);
        return new WindowInternal<M, K, WV>(defaultTrigger, initialValue, aggregator, keyFn, null, WindowType.SESSION, keySerde, windowValueSerde, null);
    }

    public static <M, K> Window<M, K, Collection<M>> keyedSessionWindow(MapFunction<? super M, ? extends K> keyFn, Duration sessionGap, Serde<K> keySerde, Serde<M> msgSerde) {
        Trigger defaultTrigger = Triggers.timeSinceLastMessage(sessionGap);
        return new WindowInternal(defaultTrigger, null, null, keyFn, null, WindowType.SESSION, keySerde, null, msgSerde);
    }
}

