/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import org.apache.samza.metrics.Metric;
import org.apache.samza.metrics.MetricsVisitor;
import org.apache.samza.metrics.Reservoir;
import org.apache.samza.metrics.SlidingTimeWindowReservoir;
import org.apache.samza.metrics.Snapshot;
import org.apache.samza.util.Clock;

public class Timer
implements Metric {
    private final String name;
    private final Reservoir reservoir;

    public Timer(String name) {
        this(name, new SlidingTimeWindowReservoir());
    }

    public Timer(String name, long windowMs, Clock clock) {
        this(name, new SlidingTimeWindowReservoir(windowMs, clock));
    }

    public Timer(String name, long windowMs, int collisionBuffer, Clock clock) {
        this(name, new SlidingTimeWindowReservoir(windowMs, collisionBuffer, clock));
    }

    public Timer(String name, Reservoir reservoir) {
        this.name = name;
        this.reservoir = reservoir;
    }

    public void update(long duration) {
        if (duration > 0L) {
            this.reservoir.update(duration);
        }
    }

    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }

    @Override
    public void visit(MetricsVisitor visitor) {
        visitor.timer(this);
    }

    public String getName() {
        return this.name;
    }
}

