/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.apache.samza.metrics.Metric;
import org.apache.samza.metrics.MetricsVisitor;
import org.apache.samza.util.TimestampedValue;

public class ListGauge<T>
implements Metric {
    private final String name;
    private final Queue<TimestampedValue<T>> elements;
    private final int maxNumberOfItems;
    private final Duration maxStaleness;
    private static final int DEFAULT_MAX_NITEMS = 1000;
    private static final Duration DEFAULT_MAX_STALENESS = Duration.ofMinutes(60L);

    public ListGauge(String name, int maxNumberOfItems, Duration maxStaleness) {
        this.name = name;
        this.elements = new ConcurrentLinkedQueue<TimestampedValue<T>>();
        this.maxNumberOfItems = maxNumberOfItems;
        this.maxStaleness = maxStaleness;
    }

    public ListGauge(String name) {
        this(name, 1000, DEFAULT_MAX_STALENESS);
    }

    public String getName() {
        return this.name;
    }

    public Collection<T> getValues() {
        this.evict();
        return Collections.unmodifiableList(this.elements.stream().map(x -> x.getValue()).collect(Collectors.toList()));
    }

    public void add(T value) {
        this.elements.add(new TimestampedValue<T>(value, Instant.now().toEpochMilli()));
        this.evict();
    }

    @Override
    public void visit(MetricsVisitor visitor) {
        visitor.listGauge(this);
    }

    private synchronized void evict() {
        this.evictBasedOnSize();
        this.evictBasedOnTimestamp();
    }

    private void evictBasedOnSize() {
        for (int numToEvict = this.elements.size() - this.maxNumberOfItems; numToEvict > 0; --numToEvict) {
            this.elements.poll();
        }
    }

    private void evictBasedOnTimestamp() {
        Instant currentTimestamp = Instant.now();
        TimestampedValue<T> valueInfo = this.elements.peek();
        while (valueInfo != null && currentTimestamp.toEpochMilli() - valueInfo.getTimestamp() > this.maxStaleness.toMillis()) {
            this.elements.poll();
            valueInfo = this.elements.peek();
        }
    }
}

