/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.model;

import java.util.Collections;
import java.util.Set;
import org.apache.samza.Partition;
import org.apache.samza.container.TaskName;
import org.apache.samza.system.SystemStreamPartition;

public class TaskModel
implements Comparable<TaskModel> {
    private final TaskName taskName;
    private final Set<SystemStreamPartition> systemStreamPartitions;
    private final Partition changelogPartition;

    public TaskModel(TaskName taskName, Set<SystemStreamPartition> systemStreamPartitions, Partition changelogPartition) {
        this.taskName = taskName;
        this.systemStreamPartitions = Collections.unmodifiableSet(systemStreamPartitions);
        this.changelogPartition = changelogPartition;
    }

    public TaskName getTaskName() {
        return this.taskName;
    }

    public Set<SystemStreamPartition> getSystemStreamPartitions() {
        return this.systemStreamPartitions;
    }

    public Partition getChangelogPartition() {
        return this.changelogPartition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskModel taskModel = (TaskModel)o;
        if (!this.changelogPartition.equals(taskModel.changelogPartition)) {
            return false;
        }
        if (!this.systemStreamPartitions.equals(taskModel.systemStreamPartitions)) {
            return false;
        }
        return this.taskName.equals(taskModel.taskName);
    }

    public int hashCode() {
        int result = this.taskName.hashCode();
        result = 31 * result + this.systemStreamPartitions.hashCode();
        result = 31 * result + this.changelogPartition.hashCode();
        return result;
    }

    public String toString() {
        return "TaskModel [taskName=" + this.taskName + ", systemStreamPartitions=" + this.systemStreamPartitions + ", changeLogPartition=" + this.changelogPartition + "]";
    }

    @Override
    public int compareTo(TaskModel other) {
        return this.taskName.compareTo(other.getTaskName());
    }
}

