/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.MapConfig;

public abstract class Config
implements Map<String, String>,
Serializable {
    public static final String SENSITIVE_PREFIX = "sensitive.";
    public static final String SENSITIVE_MASK = "********";

    public Config subset(String prefix) {
        return this.subset(prefix, true);
    }

    public Config subset(String prefix, boolean stripPrefix) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry entry : this.entrySet()) {
            String k = (String)entry.getKey();
            if (k == null || !k.startsWith(prefix)) continue;
            if (stripPrefix) {
                k = k.substring(prefix.length());
            }
            out.put(k, (String)entry.getValue());
        }
        return new MapConfig((Map<String, String>)out);
    }

    public Config regexSubset(String regex) {
        HashMap<String, String> out = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(regex);
        for (Map.Entry entry : this.entrySet()) {
            String k = (String)entry.getKey();
            Matcher matcher = pattern.matcher(k);
            if (!matcher.find()) continue;
            out.put(k, (String)entry.getValue());
        }
        return new MapConfig((Map<String, String>)out);
    }

    public String get(String k, String defaultString) {
        if (!this.containsKey(k)) {
            return defaultString;
        }
        return (String)this.get(k);
    }

    public boolean getBoolean(String k, boolean defaultValue) {
        if (this.containsKey(k)) {
            return "true".equalsIgnoreCase((String)this.get(k));
        }
        return defaultValue;
    }

    public boolean getBoolean(String k) {
        if (this.containsKey(k)) {
            return "true".equalsIgnoreCase((String)this.get(k));
        }
        throw new ConfigException("Missing key " + k + ".");
    }

    public short getShort(String k, short defaultValue) {
        if (this.containsKey(k)) {
            return Short.parseShort((String)this.get(k));
        }
        return defaultValue;
    }

    public short getShort(String k) {
        if (this.containsKey(k)) {
            return Short.parseShort((String)this.get(k));
        }
        throw new ConfigException("Missing key " + k + ".");
    }

    public long getLong(String k, long defaultValue) {
        if (this.containsKey(k)) {
            return Long.parseLong((String)this.get(k));
        }
        return defaultValue;
    }

    public long getLong(String k) {
        if (this.containsKey(k)) {
            return Long.parseLong((String)this.get(k));
        }
        throw new ConfigException("Missing key " + k + ".");
    }

    public int getInt(String k, int defaultValue) {
        if (this.containsKey(k)) {
            return Integer.parseInt((String)this.get(k));
        }
        return defaultValue;
    }

    public int getInt(String k) {
        if (this.containsKey(k)) {
            return Integer.parseInt((String)this.get(k));
        }
        throw new ConfigException("Missing key " + k + ".");
    }

    public double getDouble(String k, double defaultValue) {
        if (this.containsKey(k)) {
            return Double.parseDouble((String)this.get(k));
        }
        return defaultValue;
    }

    public double getDouble(String k) {
        if (this.containsKey(k)) {
            return Double.parseDouble((String)this.get(k));
        }
        throw new ConfigException("Missing key " + k + ".");
    }

    public List<String> getList(String k, List<String> defaultValue) {
        if (!this.containsKey(k)) {
            return defaultValue;
        }
        String value = (String)this.get(k);
        if (value.trim().isEmpty()) {
            return defaultValue;
        }
        String[] pieces = value.split("\\s*,\\s*");
        return Arrays.asList(pieces);
    }

    public List<String> getList(String k) {
        if (!this.containsKey(k)) {
            throw new ConfigException("Missing key " + k + ".");
        }
        return this.getList(k, null);
    }

    public <T> Class<T> getClass(String k) {
        if (this.containsKey(k)) {
            try {
                return Class.forName((String)this.get(k));
            }
            catch (Exception e) {
                throw new ConfigException("Unable to find class.", e);
            }
        }
        throw new ConfigException("Missing key " + k + ".");
    }

    public <T> T getNewInstance(String k) {
        try {
            return this.getClass(k).newInstance();
        }
        catch (Exception e) {
            throw new ConfigException("Unable to instantiate class.", e);
        }
    }

    public Date getDate(String k) {
        return this.getDate(k, new SimpleDateFormat());
    }

    public Date getDate(String k, String format) {
        return this.getDate(k, new SimpleDateFormat(format));
    }

    public Date getDate(String k, SimpleDateFormat format) {
        if (!this.containsKey(k)) {
            throw new ConfigException("Missing key " + k + ".");
        }
        try {
            return format.parse((String)this.get(k));
        }
        catch (ParseException e) {
            throw new ConfigException("Date format exception.", e);
        }
    }

    public Date getDate(String k, Date defaultValue) {
        return this.getDate(k, new SimpleDateFormat(), defaultValue);
    }

    public Date getDate(String k, String format, Date defaultValue) {
        return this.getDate(k, new SimpleDateFormat(format), defaultValue);
    }

    public Date getDate(String k, SimpleDateFormat format, Date defaultValue) {
        if (!this.containsKey(k)) {
            return defaultValue;
        }
        try {
            return format.parse((String)this.get(k));
        }
        catch (ParseException e) {
            throw new ConfigException("Date format exception.", e);
        }
    }

    public abstract Config sanitize();

    @Override
    public void clear() {
        throw new ConfigException("Config is immutable.");
    }

    @Override
    public String put(String key, String value) {
        throw new ConfigException("Config is immutable.");
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw new ConfigException("Config is immutable.");
    }

    @Override
    public String remove(Object s) {
        throw new ConfigException("Config is immutable.");
    }
}

