/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.translator;

import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.sql.data.RexToJavaCompiler;
import org.apache.samza.sql.data.SamzaSqlExecutionContext;
import org.apache.samza.sql.interfaces.SamzaRelConverter;
import org.apache.samza.system.descriptors.DelegatingSystemDescriptor;

public class TranslatorContext
implements Cloneable {
    private final StreamApplicationDescriptor streamAppDesc;
    private final RexToJavaCompiler compiler;
    private final Map<String, SamzaRelConverter> relSamzaConverters;
    private final Map<Integer, MessageStream> messageStreams;
    private final Map<Integer, RelNode> relNodes;
    private final Map<String, DelegatingSystemDescriptor> systemDescriptors;
    private final SamzaSqlExecutionContext executionContext;
    private final DataContextImpl dataContext;

    private RexToJavaCompiler createExpressionCompiler(RelRoot relRoot) {
        RelDataTypeFactory dataTypeFactory = relRoot.project().getCluster().getTypeFactory();
        SamzaSqlRexBuilder rexBuilder = new SamzaSqlRexBuilder(dataTypeFactory);
        return new RexToJavaCompiler(rexBuilder);
    }

    private TranslatorContext(TranslatorContext other) {
        this.streamAppDesc = other.streamAppDesc;
        this.compiler = other.compiler;
        this.relSamzaConverters = other.relSamzaConverters;
        this.messageStreams = other.messageStreams;
        this.relNodes = other.relNodes;
        this.executionContext = other.executionContext.clone();
        this.dataContext = new DataContextImpl();
        this.systemDescriptors = other.systemDescriptors;
    }

    public TranslatorContext(StreamApplicationDescriptor streamAppDesc, RelRoot relRoot, SamzaSqlExecutionContext executionContext, Map<String, SamzaRelConverter> converters) {
        this.streamAppDesc = streamAppDesc;
        this.compiler = this.createExpressionCompiler(relRoot);
        this.executionContext = executionContext;
        this.dataContext = new DataContextImpl();
        this.relSamzaConverters = converters;
        this.messageStreams = new HashMap<Integer, MessageStream>();
        this.relNodes = new HashMap<Integer, RelNode>();
        this.systemDescriptors = new HashMap<String, DelegatingSystemDescriptor>();
    }

    public StreamApplicationDescriptor getStreamAppDescriptor() {
        return this.streamAppDesc;
    }

    SamzaSqlExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    DataContext getDataContext() {
        return this.dataContext;
    }

    RexToJavaCompiler getExpressionCompiler() {
        return this.compiler;
    }

    void registerMessageStream(int id, MessageStream stream) {
        this.messageStreams.put(id, stream);
    }

    MessageStream getMessageStream(int id) {
        return this.messageStreams.get(id);
    }

    void registerRelNode(int id, RelNode relNode) {
        this.relNodes.put(id, relNode);
    }

    RelNode getRelNode(int id) {
        return this.relNodes.get(id);
    }

    SamzaRelConverter getMsgConverter(String source) {
        return this.relSamzaConverters.get(source);
    }

    public TranslatorContext clone() {
        return new TranslatorContext(this);
    }

    private static class SamzaSqlRexBuilder
    extends RexBuilder {
        private SamzaSqlRexBuilder(RelDataTypeFactory typeFactory) {
            super(typeFactory);
        }

        public RexNode ensureType(RelDataType type, RexNode node, boolean matchNullability) {
            return node;
        }
    }

    private static class DataContextImpl
    implements DataContext {
        private DataContextImpl() {
        }

        public SchemaPlus getRootSchema() {
            return null;
        }

        public JavaTypeFactory getTypeFactory() {
            return null;
        }

        public QueryProvider getQueryProvider() {
            return null;
        }

        public Object get(String name) {
            TimeZone timeZone = TimeZone.getDefault();
            long timeMs = System.currentTimeMillis();
            long offsetMs = timeZone.getOffset(timeMs);
            if (name.equals(DataContext.Variable.LOCAL_TIMESTAMP.camelName)) {
                return timeMs + offsetMs;
            }
            if (name.equals(DataContext.Variable.UTC_TIMESTAMP.camelName) || name.equals(DataContext.Variable.CURRENT_TIMESTAMP.camelName)) {
                return timeMs;
            }
            if (name.equals(DataContext.Variable.TIME_ZONE.camelName)) {
                return timeZone;
            }
            throw new UnsupportedOperationException("Unsupported operation " + name);
        }
    }
}

