/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.translator;

import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.core.TableScan;
import org.apache.commons.lang.Validate;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.context.Context;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.interfaces.SamzaRelConverter;
import org.apache.samza.sql.interfaces.SqlIOConfig;
import org.apache.samza.sql.runner.SamzaSqlApplicationContext;
import org.apache.samza.sql.translator.TranslatorContext;
import org.apache.samza.system.descriptors.DelegatingSystemDescriptor;
import org.apache.samza.system.descriptors.GenericInputDescriptor;
import org.apache.samza.system.descriptors.InputDescriptor;

class ScanTranslator {
    private final Map<String, SamzaRelConverter> relMsgConverters;
    private final Map<String, SqlIOConfig> systemStreamConfig;
    private final int queryId;

    ScanTranslator(Map<String, SamzaRelConverter> converters, Map<String, SqlIOConfig> ssc, int queryId) {
        this.relMsgConverters = converters;
        this.systemStreamConfig = ssc;
        this.queryId = queryId;
    }

    void translate(TableScan tableScan, TranslatorContext context, Map<String, DelegatingSystemDescriptor> systemDescriptors, Map<String, MessageStream<KV<Object, Object>>> inputMsgStreams) {
        StreamApplicationDescriptor streamAppDesc = context.getStreamAppDescriptor();
        List tableNameParts = tableScan.getTable().getQualifiedName();
        String sourceName = SqlIOConfig.getSourceFromSourceParts(tableNameParts);
        Validate.isTrue((boolean)this.relMsgConverters.containsKey(sourceName), (String)String.format("Unknown source %s", sourceName));
        SqlIOConfig sqlIOConfig = this.systemStreamConfig.get(sourceName);
        String systemName = sqlIOConfig.getSystemName();
        String streamName = sqlIOConfig.getStreamName();
        String source = sqlIOConfig.getSource();
        KVSerde noOpKVSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
        DelegatingSystemDescriptor sd = systemDescriptors.computeIfAbsent(systemName, DelegatingSystemDescriptor::new);
        GenericInputDescriptor isd = sd.getInputDescriptor(streamName, (Serde)noOpKVSerde);
        MessageStream inputStream = inputMsgStreams.computeIfAbsent(source, v -> streamAppDesc.getInputStream((InputDescriptor)isd));
        MessageStream samzaSqlRelMessageStream = inputStream.map((MapFunction)new ScanMapFunction(sourceName, this.queryId));
        context.registerMessageStream(tableScan.getId(), samzaSqlRelMessageStream);
    }

    private static class ScanMapFunction
    implements MapFunction<KV<Object, Object>, SamzaSqlRelMessage> {
        private transient SamzaRelConverter msgConverter;
        private final String streamName;
        private final int queryId;

        ScanMapFunction(String sourceStreamName, int queryId) {
            this.streamName = sourceStreamName;
            this.queryId = queryId;
        }

        public void init(Context context) {
            TranslatorContext translatorContext = ((SamzaSqlApplicationContext)context.getApplicationTaskContext()).getTranslatorContexts().get(this.queryId);
            this.msgConverter = translatorContext.getMsgConverter(this.streamName);
        }

        public SamzaSqlRelMessage apply(KV<Object, Object> message) {
            return this.msgConverter.convertToRelMessage(message);
        }
    }
}

