/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.translator;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.commons.lang.Validate;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.functions.StreamTableJoinFunction;
import org.apache.samza.sql.data.SamzaSqlCompositeKey;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaSqlRelMessageJoinFunction
implements StreamTableJoinFunction<SamzaSqlCompositeKey, SamzaSqlRelMessage, KV<SamzaSqlCompositeKey, SamzaSqlRelMessage>, SamzaSqlRelMessage> {
    private static final Logger log = LoggerFactory.getLogger(SamzaSqlRelMessageJoinFunction.class);
    private final JoinRelType joinRelType;
    private final boolean isTablePosOnRight;
    private final ArrayList<Integer> streamFieldIds;
    private final ArrayList<String> tableFieldNames;
    private final ArrayList<String> outFieldNames;

    SamzaSqlRelMessageJoinFunction(JoinRelType joinRelType, boolean isTablePosOnRight, List<Integer> streamFieldIds, List<String> streamFieldNames, List<String> tableFieldNames) {
        this.joinRelType = joinRelType;
        this.isTablePosOnRight = isTablePosOnRight;
        Validate.isTrue((joinRelType.compareTo((Enum)JoinRelType.LEFT) == 0 && isTablePosOnRight || joinRelType.compareTo((Enum)JoinRelType.RIGHT) == 0 && !isTablePosOnRight || joinRelType.compareTo((Enum)JoinRelType.INNER) == 0 ? 1 : 0) != 0);
        this.streamFieldIds = new ArrayList<Integer>(streamFieldIds);
        this.tableFieldNames = new ArrayList<String>(tableFieldNames);
        this.outFieldNames = new ArrayList();
        if (isTablePosOnRight) {
            this.outFieldNames.addAll(streamFieldNames);
        }
        this.outFieldNames.addAll(tableFieldNames);
        if (!isTablePosOnRight) {
            this.outFieldNames.addAll(streamFieldNames);
        }
    }

    public SamzaSqlRelMessage apply(SamzaSqlRelMessage message, KV<SamzaSqlCompositeKey, SamzaSqlRelMessage> record) {
        if (this.joinRelType.compareTo((Enum)JoinRelType.INNER) == 0 && record == null) {
            log.debug("Inner Join: Record not found for the message with key: " + this.getMessageKey(message));
            return null;
        }
        ArrayList<Object> outFieldValues = new ArrayList<Object>();
        if (this.isTablePosOnRight) {
            outFieldValues.addAll(message.getSamzaSqlRelRecord().getFieldValues());
        }
        if (record != null) {
            outFieldValues.addAll(((SamzaSqlRelMessage)record.getValue()).getSamzaSqlRelRecord().getFieldValues());
        } else {
            this.tableFieldNames.forEach(s -> outFieldValues.add(null));
        }
        if (!this.isTablePosOnRight) {
            outFieldValues.addAll(message.getSamzaSqlRelRecord().getFieldValues());
        }
        return new SamzaSqlRelMessage(this.outFieldNames, outFieldValues);
    }

    public SamzaSqlCompositeKey getMessageKey(SamzaSqlRelMessage message) {
        return SamzaSqlCompositeKey.createSamzaSqlCompositeKey(message, this.streamFieldIds);
    }

    public SamzaSqlCompositeKey getRecordKey(KV<SamzaSqlCompositeKey, SamzaSqlRelMessage> record) {
        return (SamzaSqlCompositeKey)record.getKey();
    }

    public void close() {
    }
}

