/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.translator;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.samza.SamzaException;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.context.ApplicationTaskContextFactory;
import org.apache.samza.context.Context;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.sql.data.SamzaSqlExecutionContext;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.interfaces.SamzaRelConverter;
import org.apache.samza.sql.interfaces.SqlIOConfig;
import org.apache.samza.sql.interfaces.SqlIOResolver;
import org.apache.samza.sql.planner.QueryPlanner;
import org.apache.samza.sql.runner.SamzaSqlApplicationConfig;
import org.apache.samza.sql.runner.SamzaSqlApplicationContext;
import org.apache.samza.sql.testutil.SamzaSqlQueryParser;
import org.apache.samza.sql.translator.FilterTranslator;
import org.apache.samza.sql.translator.JoinTranslator;
import org.apache.samza.sql.translator.LogicalAggregateTranslator;
import org.apache.samza.sql.translator.ModifyTranslator;
import org.apache.samza.sql.translator.ProjectTranslator;
import org.apache.samza.sql.translator.ScanTranslator;
import org.apache.samza.sql.translator.TranslatorContext;
import org.apache.samza.system.descriptors.DelegatingSystemDescriptor;
import org.apache.samza.system.descriptors.GenericOutputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.table.Table;
import org.apache.samza.table.descriptors.TableDescriptor;

public class QueryTranslator {
    private final SamzaSqlApplicationConfig sqlConfig;
    private final StreamApplicationDescriptor streamAppDescriptor;
    private final Map<String, DelegatingSystemDescriptor> systemDescriptors;
    private final Map<String, MessageStream<KV<Object, Object>>> inputMsgStreams;
    private final Map<String, OutputStream> outputMsgStreams;

    public QueryTranslator(StreamApplicationDescriptor appDesc, SamzaSqlApplicationConfig sqlConfig) {
        this.sqlConfig = sqlConfig;
        this.streamAppDescriptor = appDesc;
        this.systemDescriptors = new HashMap<String, DelegatingSystemDescriptor>();
        this.outputMsgStreams = new HashMap<String, OutputStream>();
        this.inputMsgStreams = new HashMap<String, MessageStream<KV<Object, Object>>>();
    }

    @VisibleForTesting
    public void translate(SamzaSqlQueryParser.QueryInfo queryInfo, StreamApplicationDescriptor appDesc) {
        QueryPlanner planner = new QueryPlanner(this.sqlConfig.getRelSchemaProviders(), this.sqlConfig.getSystemStreamConfigsBySource(), this.sqlConfig.getUdfMetadata());
        RelRoot relRoot = planner.plan(queryInfo.getSql());
        int queryId = 1;
        SamzaSqlExecutionContext executionContext = new SamzaSqlExecutionContext(this.sqlConfig);
        Map<String, SamzaRelConverter> converters = this.sqlConfig.getSamzaRelConverters();
        TranslatorContext translatorContext = new TranslatorContext(appDesc, relRoot, executionContext, converters);
        this.translate(relRoot, translatorContext, queryId);
        HashMap<Integer, TranslatorContext> translatorContexts = new HashMap<Integer, TranslatorContext>();
        translatorContexts.put(queryId, translatorContext.clone());
        appDesc.withApplicationTaskContextFactory((ApplicationTaskContextFactory & Serializable)(jobContext, containerContext, taskContext, applicationContainerContext) -> new SamzaSqlApplicationContext(translatorContexts));
    }

    public void translate(RelRoot relRoot, final TranslatorContext translatorContext, final int queryId) {
        final SqlIOResolver ioResolver = translatorContext.getExecutionContext().getSamzaSqlApplicationConfig().getIoResolver();
        RelNode node = relRoot.project();
        final ScanTranslator scanTranslator = new ScanTranslator(this.sqlConfig.getSamzaRelConverters(), this.sqlConfig.getInputSystemStreamConfigBySource(), queryId);
        final ModifyTranslator modifyTranslator = new ModifyTranslator(this.sqlConfig.getSamzaRelConverters(), this.sqlConfig.getOutputSystemStreamConfigsBySource(), queryId);
        node.accept((RelShuttle)new RelShuttleImpl(){
            int windowId = 0;
            int joinId = 0;

            public RelNode visit(RelNode relNode) {
                if (relNode instanceof TableModify) {
                    return this.visit((TableModify)relNode);
                }
                return super.visit(relNode);
            }

            private RelNode visit(TableModify modify) {
                if (!modify.isInsert()) {
                    throw new SamzaException("Not a supported operation: " + modify.toString());
                }
                RelNode node = super.visit((RelNode)modify);
                modifyTranslator.translate(modify, translatorContext, QueryTranslator.this.systemDescriptors, QueryTranslator.this.outputMsgStreams);
                return node;
            }

            public RelNode visit(TableScan scan) {
                RelNode node = super.visit(scan);
                scanTranslator.translate(scan, translatorContext, QueryTranslator.this.systemDescriptors, QueryTranslator.this.inputMsgStreams);
                return node;
            }

            public RelNode visit(LogicalFilter filter) {
                RelNode node = this.visitChild((RelNode)filter, 0, filter.getInput());
                new FilterTranslator(queryId).translate(filter, translatorContext);
                return node;
            }

            public RelNode visit(LogicalProject project) {
                RelNode node = super.visit(project);
                new ProjectTranslator(queryId).translate((Project)project, translatorContext);
                return node;
            }

            public RelNode visit(LogicalJoin join) {
                RelNode node = super.visit(join);
                ++this.joinId;
                new JoinTranslator(this.joinId, ioResolver).translate(join, translatorContext);
                return node;
            }

            public RelNode visit(LogicalAggregate aggregate) {
                RelNode node = super.visit(aggregate);
                ++this.windowId;
                new LogicalAggregateTranslator(this.windowId).translate(aggregate, translatorContext);
                return node;
            }
        });
        this.sqlConfig.getOutputSystemStreamConfigsBySource().keySet().forEach(key -> {
            if (key.split("\\.")[0].equals("log")) {
                this.sendToOutputStream(this.streamAppDescriptor, translatorContext, node, queryId);
            }
        });
    }

    private void sendToOutputStream(StreamApplicationDescriptor appDesc, TranslatorContext context, RelNode node, int queryId) {
        SqlIOConfig sinkConfig = this.sqlConfig.getOutputSystemStreamConfigsBySource().get("log");
        MessageStream stream = context.getMessageStream(node.getId());
        MessageStream outputStream = stream.map((MapFunction)new OutputMapFunction("log", queryId));
        Optional<TableDescriptor> tableDescriptor = sinkConfig.getTableDescriptor();
        if (!tableDescriptor.isPresent()) {
            KVSerde noOpKVSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
            String systemName = sinkConfig.getSystemName();
            DelegatingSystemDescriptor sd = this.systemDescriptors.computeIfAbsent(systemName, DelegatingSystemDescriptor::new);
            GenericOutputDescriptor osd = sd.getOutputDescriptor(sinkConfig.getStreamName(), (Serde)noOpKVSerde);
            if (OutputMapFunction.logOutputStream == null) {
                OutputMapFunction.logOutputStream = appDesc.getOutputStream((OutputDescriptor)osd);
            }
            outputStream.sendTo(OutputMapFunction.logOutputStream);
        } else {
            Table outputTable = appDesc.getTable(tableDescriptor.get());
            if (outputTable == null) {
                String msg = "Failed to obtain table descriptor of " + sinkConfig.getSource();
                throw new SamzaException(msg);
            }
            outputStream.sendTo(outputTable);
        }
    }

    private static class OutputMapFunction
    implements MapFunction<SamzaSqlRelMessage, KV<Object, Object>> {
        private transient SamzaRelConverter samzaMsgConverter;
        private final String outputTopic;
        private final int queryId;
        static OutputStream logOutputStream;

        OutputMapFunction(String outputTopic, int queryId) {
            this.outputTopic = outputTopic;
            this.queryId = queryId;
        }

        public void init(Context context) {
            TranslatorContext translatorContext = ((SamzaSqlApplicationContext)context.getApplicationTaskContext()).getTranslatorContexts().get(this.queryId);
            this.samzaMsgConverter = translatorContext.getMsgConverter(this.outputTopic);
        }

        public KV<Object, Object> apply(SamzaSqlRelMessage message) {
            return this.samzaMsgConverter.convertToSamzaMessage(message);
        }
    }
}

