/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.translator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.util.Pair;
import org.apache.samza.SamzaException;
import org.apache.samza.context.Context;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.sql.data.Expression;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.runner.SamzaSqlApplicationContext;
import org.apache.samza.sql.translator.TranslatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectTranslator.class);
    private final int queryId;

    ProjectTranslator(int queryId) {
        this.queryId = queryId;
    }

    private MessageStream<SamzaSqlRelMessage> translateFlatten(Integer flattenIndex, MessageStream<SamzaSqlRelMessage> inputStream) {
        return inputStream.flatMap((FlatMapFunction & Serializable)message -> {
            Object field = message.getSamzaSqlRelRecord().getFieldValues().get(flattenIndex);
            if (field != null && field instanceof List) {
                ArrayList<SamzaSqlRelMessage> outMessages = new ArrayList<SamzaSqlRelMessage>();
                for (Object fieldValue : (List)field) {
                    ArrayList<Object> newValues = new ArrayList<Object>(message.getSamzaSqlRelRecord().getFieldValues());
                    newValues.set(flattenIndex, Collections.singletonList(fieldValue));
                    outMessages.add(new SamzaSqlRelMessage(message.getSamzaSqlRelRecord().getFieldNames(), newValues));
                }
                return outMessages;
            }
            return Collections.singletonList(message);
        });
    }

    private boolean isFlatten(RexNode rexNode) {
        return rexNode instanceof RexCall && ((RexCall)rexNode).op instanceof SqlUserDefinedFunction && ((RexCall)rexNode).op.getName().equalsIgnoreCase("flatten");
    }

    private Integer getProjectIndex(RexNode rexNode) {
        return ((RexInputRef)((RexCall)rexNode).getOperands().get(0)).getIndex();
    }

    void translate(Project project, TranslatorContext context) {
        MessageStream<SamzaSqlRelMessage> messageStream = context.getMessageStream(project.getInput().getId());
        List flattenProjects = project.getProjects().stream().filter(this::isFlatten).map(this::getProjectIndex).collect(Collectors.toList());
        if (flattenProjects.size() > 0) {
            if (flattenProjects.size() > 1) {
                String msg = "Multiple flatten operators in a single query is not supported";
                LOG.error(msg);
                throw new SamzaException(msg);
            }
            messageStream = this.translateFlatten((Integer)flattenProjects.get(0), messageStream);
        }
        int projectId = project.getId();
        MessageStream outputStream = messageStream.map((MapFunction)new ProjectMapFunction(projectId, this.queryId));
        context.registerMessageStream(project.getId(), outputStream);
        context.registerRelNode(project.getId(), (RelNode)project);
    }

    private static class ProjectMapFunction
    implements MapFunction<SamzaSqlRelMessage, SamzaSqlRelMessage> {
        private transient Project project;
        private transient Expression expr;
        private transient TranslatorContext context;
        private final int queryId;
        private final int projectId;

        ProjectMapFunction(int projectId, int queryId) {
            this.projectId = projectId;
            this.queryId = queryId;
        }

        public void init(Context context) {
            this.context = ((SamzaSqlApplicationContext)context.getApplicationTaskContext()).getTranslatorContexts().get(this.queryId);
            this.project = (Project)this.context.getRelNode(this.projectId);
            this.expr = this.context.getExpressionCompiler().compile(this.project.getInputs(), this.project.getProjects());
        }

        public SamzaSqlRelMessage apply(SamzaSqlRelMessage message) {
            RelDataType type = this.project.getRowType();
            Object[] output = new Object[type.getFieldCount()];
            this.expr.execute(this.context.getExecutionContext(), this.context.getDataContext(), message.getSamzaSqlRelRecord().getFieldValues().toArray(), output);
            ArrayList<String> names = new ArrayList<String>();
            for (int index = 0; index < output.length; ++index) {
                names.add(index, (String)((Pair)this.project.getNamedProjects().get(index)).getValue());
            }
            return new SamzaSqlRelMessage(names, Arrays.asList(output));
        }
    }
}

