/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.translator;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.rel.core.TableModify;
import org.apache.commons.lang.Validate;
import org.apache.samza.SamzaException;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.context.Context;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.MessageStreamImpl;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.NoOpSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.interfaces.SamzaRelConverter;
import org.apache.samza.sql.interfaces.SqlIOConfig;
import org.apache.samza.sql.runner.SamzaSqlApplicationContext;
import org.apache.samza.sql.translator.TranslatorContext;
import org.apache.samza.system.descriptors.DelegatingSystemDescriptor;
import org.apache.samza.system.descriptors.GenericOutputDescriptor;
import org.apache.samza.system.descriptors.OutputDescriptor;
import org.apache.samza.table.Table;
import org.apache.samza.table.descriptors.TableDescriptor;

class ModifyTranslator {
    private final Map<String, SamzaRelConverter> relMsgConverters;
    private final Map<String, SqlIOConfig> systemStreamConfig;
    private final int queryId;

    ModifyTranslator(Map<String, SamzaRelConverter> converters, Map<String, SqlIOConfig> ssc, int queryId) {
        this.relMsgConverters = converters;
        this.systemStreamConfig = ssc;
        this.queryId = queryId;
    }

    void translate(TableModify tableModify, TranslatorContext context, Map<String, DelegatingSystemDescriptor> systemDescriptors, Map<String, OutputStream> outputMsgStreams) {
        StreamApplicationDescriptor streamAppDesc = context.getStreamAppDescriptor();
        List tableNameParts = tableModify.getTable().getQualifiedName();
        String targetName = SqlIOConfig.getSourceFromSourceParts(tableNameParts);
        Validate.isTrue((boolean)this.relMsgConverters.containsKey(targetName), (String)String.format("Unknown source %s", targetName));
        SqlIOConfig sinkConfig = this.systemStreamConfig.get(targetName);
        String systemName = sinkConfig.getSystemName();
        String streamName = sinkConfig.getStreamName();
        String source = sinkConfig.getSource();
        KVSerde noOpKVSerde = KVSerde.of((Serde)new NoOpSerde(), (Serde)new NoOpSerde());
        DelegatingSystemDescriptor sd = systemDescriptors.computeIfAbsent(systemName, DelegatingSystemDescriptor::new);
        GenericOutputDescriptor osd = sd.getOutputDescriptor(streamName, (Serde)noOpKVSerde);
        MessageStreamImpl stream = (MessageStreamImpl)context.getMessageStream(tableModify.getInput().getId());
        MessageStream outputStream = stream.map((MapFunction)new OutputMapFunction(targetName, this.queryId));
        Optional<TableDescriptor> tableDescriptor = sinkConfig.getTableDescriptor();
        if (!tableDescriptor.isPresent()) {
            OutputStream stm = outputMsgStreams.computeIfAbsent(source, v -> streamAppDesc.getOutputStream((OutputDescriptor)osd));
            outputStream.sendTo(stm);
        } else {
            Table outputTable = streamAppDesc.getTable(tableDescriptor.get());
            if (outputTable == null) {
                String msg = "Failed to obtain table descriptor of " + sinkConfig.getSource();
                throw new SamzaException(msg);
            }
            outputStream.sendTo(outputTable);
        }
    }

    private static class OutputMapFunction
    implements MapFunction<SamzaSqlRelMessage, KV<Object, Object>> {
        private transient SamzaRelConverter samzaMsgConverter;
        private final String outputTopic;
        private final int queryId;

        OutputMapFunction(String outputTopic, int queryId) {
            this.outputTopic = outputTopic;
            this.queryId = queryId;
        }

        public void init(Context context) {
            TranslatorContext translatorContext = ((SamzaSqlApplicationContext)context.getApplicationTaskContext()).getTranslatorContexts().get(this.queryId);
            this.samzaMsgConverter = translatorContext.getMsgConverter(this.outputTopic);
        }

        public KV<Object, Object> apply(SamzaSqlRelMessage message) {
            return this.samzaMsgConverter.convertToSamzaMessage(message);
        }
    }
}

