/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.translator;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.sql.SqlKind;
import org.apache.samza.SamzaException;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.FoldLeftFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SupplierFunction;
import org.apache.samza.operators.windows.AccumulationMode;
import org.apache.samza.operators.windows.Windows;
import org.apache.samza.serializers.LongSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.serializers.SamzaSqlRelMessageSerdeFactory;
import org.apache.samza.sql.translator.JoinTranslator;
import org.apache.samza.sql.translator.TranslatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogicalAggregateTranslator {
    private static final Logger log = LoggerFactory.getLogger(JoinTranslator.class);
    private int windowId;

    LogicalAggregateTranslator(int windowId) {
        this.windowId = windowId;
    }

    void translate(LogicalAggregate aggregate, TranslatorContext context) {
        this.validateAggregateFunctions(aggregate);
        MessageStream inputStream = context.getMessageStream(aggregate.getInput().getId());
        SupplierFunction & Serializable initialValue = (SupplierFunction & Serializable)() -> 0L;
        FoldLeftFunction & Serializable foldCountFn = (FoldLeftFunction & Serializable)(m, c) -> c + 1L;
        ArrayList<String> aggFieldNames = this.getAggFieldNames(aggregate);
        MessageStream outputStream = inputStream.window(Windows.keyedTumblingWindow((MapFunction & Serializable)m -> m, (Duration)Duration.ofMillis(context.getExecutionContext().getSamzaSqlApplicationConfig().getWindowDurationMs()), (SupplierFunction)initialValue, (FoldLeftFunction)foldCountFn, (Serde)new SamzaSqlRelMessageSerdeFactory.SamzaSqlRelMessageSerde(), (Serde)new LongSerde()).setAccumulationMode(AccumulationMode.DISCARDING), "tumblingWindow_" + this.windowId).map((MapFunction & Serializable)windowPane -> {
            List fieldNames = ((SamzaSqlRelMessage)windowPane.getKey().getKey()).getSamzaSqlRelRecord().getFieldNames();
            List fieldValues = ((SamzaSqlRelMessage)windowPane.getKey().getKey()).getSamzaSqlRelRecord().getFieldValues();
            fieldNames.add(aggFieldNames.get(0));
            fieldValues.add(windowPane.getMessage());
            return new SamzaSqlRelMessage(fieldNames, fieldValues);
        });
        context.registerMessageStream(aggregate.getId(), outputStream);
    }

    private ArrayList<String> getAggFieldNames(LogicalAggregate aggregate) {
        return aggregate.getAggCallList().stream().collect(ArrayList::new, (names, aggCall) -> names.add(aggCall.getName()), (n1, n2) -> n1.addAll(n2));
    }

    void validateAggregateFunctions(LogicalAggregate aggregate) {
        if (aggregate.getAggCallList().size() != 1) {
            String errMsg = "Windowing is supported ONLY with one aggregate function but the number of given functions are " + aggregate.getAggCallList().size();
            log.error(errMsg);
            throw new SamzaException(errMsg);
        }
        if (((AggregateCall)aggregate.getAggCallList().get(0)).getAggregation().getKind() != SqlKind.COUNT) {
            String errMsg = "Windowing is supported ONLY with COUNT aggregate function";
            log.error(errMsg);
            throw new SamzaException(errMsg);
        }
    }
}

