/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.translator;

import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.samza.context.Context;
import org.apache.samza.operators.MessageStream;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.sql.data.Expression;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.runner.SamzaSqlApplicationContext;
import org.apache.samza.sql.translator.TranslatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilterTranslator {
    private static final Logger log = LoggerFactory.getLogger(FilterTranslator.class);
    private final int queryId;

    FilterTranslator(int queryId) {
        this.queryId = queryId;
    }

    void translate(LogicalFilter filter, TranslatorContext context) {
        MessageStream inputStream = context.getMessageStream(filter.getInput().getId());
        int filterId = filter.getId();
        MessageStream outputStream = inputStream.filter((FilterFunction)new FilterTranslatorFunction(filterId, this.queryId));
        context.registerMessageStream(filterId, outputStream);
        context.registerRelNode(filterId, (RelNode)filter);
    }

    private static class FilterTranslatorFunction
    implements FilterFunction<SamzaSqlRelMessage> {
        private transient Expression expr;
        private transient TranslatorContext context;
        private transient LogicalFilter filter;
        private final int queryId;
        private final int filterId;

        FilterTranslatorFunction(int filterId, int queryId) {
            this.filterId = filterId;
            this.queryId = queryId;
        }

        public void init(Context context) {
            this.context = ((SamzaSqlApplicationContext)context.getApplicationTaskContext()).getTranslatorContexts().get(this.queryId);
            this.filter = (LogicalFilter)this.context.getRelNode(this.filterId);
            this.expr = this.context.getExpressionCompiler().compile(this.filter.getInputs(), Collections.singletonList(this.filter.getCondition()));
        }

        public boolean apply(SamzaSqlRelMessage message) {
            Object[] result = new Object[1];
            this.expr.execute(this.context.getExecutionContext(), this.context.getDataContext(), message.getSamzaSqlRelRecord().getFieldValues().toArray(), result);
            if (result.length > 0 && result[0] instanceof Boolean) {
                boolean retVal = (Boolean)result[0];
                log.debug(String.format("return value for input %s is %s", Arrays.asList(message.getSamzaSqlRelRecord().getFieldValues()).toString(), retVal));
                return retVal;
            }
            log.error("return value is not boolean");
            return false;
        }
    }
}

