/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.testutil;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.samza.SamzaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFileParser {
    private static final String INSERT_CMD = "insert";
    private static final Logger LOG = LoggerFactory.getLogger(SqlFileParser.class);
    private static final String SQL_COMMENT_PREFIX = "--";

    private SqlFileParser() {
    }

    public static List<String> parseSqlFile(String fileName) {
        List sqlLines;
        Validate.notEmpty((String)fileName, (String)"fileName cannot be empty.");
        try {
            sqlLines = Files.lines(Paths.get(fileName, new String[0])).collect(Collectors.toList());
        }
        catch (IOException e) {
            String msg = String.format("Unable to parse the sql file %s", fileName);
            LOG.error(msg, (Throwable)e);
            throw new SamzaException(msg, (Throwable)e);
        }
        ArrayList<String> sqlStmts = new ArrayList<String>();
        String lastStatement = "";
        for (String sqlLine : sqlLines) {
            String sql = sqlLine.trim();
            if (sql.toLowerCase().startsWith(INSERT_CMD)) {
                if (StringUtils.isNotEmpty((String)lastStatement)) {
                    sqlStmts.add(lastStatement);
                }
                lastStatement = sql;
                continue;
            }
            if (!StringUtils.isNotBlank((String)sql) || sql.startsWith(SQL_COMMENT_PREFIX)) continue;
            lastStatement = String.format("%s %s", lastStatement, sql);
        }
        if (!StringUtils.isWhitespace((String)lastStatement)) {
            sqlStmts.add(lastStatement);
        }
        return sqlStmts;
    }
}

