/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.testutil;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUnnestOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.samza.SamzaException;
import org.apache.samza.sql.interfaces.SamzaSqlDriver;
import org.apache.samza.sql.interfaces.SamzaSqlJavaTypeFactoryImpl;

public class SamzaSqlQueryParser {
    private SamzaSqlQueryParser() {
    }

    public static QueryInfo parseQuery(String sql) {
        String sink;
        SqlInsert sqlInsert;
        SqlNode sqlNode;
        Pattern insertIntoSqlPattern = Pattern.compile("insert into (.*) (select .* from (.*))", 2);
        Matcher m = insertIntoSqlPattern.matcher(sql);
        if (!m.matches()) {
            throw new SamzaException("Invalid query format");
        }
        Planner planner = SamzaSqlQueryParser.createPlanner();
        try {
            sqlNode = planner.parse(sql);
        }
        catch (SqlParseException e) {
            throw new SamzaException((Throwable)e);
        }
        if (sqlNode instanceof SqlInsert) {
            sqlInsert = (SqlInsert)sqlNode;
            sink = sqlInsert.getTargetTable().toString();
            if (!(sqlInsert.getSource() instanceof SqlSelect)) {
                throw new SamzaException("Sql query is not of the expected format");
            }
        } else {
            throw new SamzaException("Sql query is not of the expected format");
        }
        SqlSelect sqlSelect = (SqlSelect)sqlInsert.getSource();
        String selectQuery = m.group(2);
        ArrayList<String> sources = SamzaSqlQueryParser.getSourcesFromSelectQuery(sqlSelect);
        return new QueryInfo(selectQuery, sources, sink, sql);
    }

    private static Planner createPlanner() {
        SchemaPlus rootSchema;
        try {
            SamzaSqlJavaTypeFactoryImpl typeFactory = new SamzaSqlJavaTypeFactoryImpl();
            SamzaSqlDriver driver = new SamzaSqlDriver((JavaTypeFactory)typeFactory);
            DriverManager.deregisterDriver(DriverManager.getDriver("jdbc:calcite:"));
            DriverManager.registerDriver((Driver)((Object)driver));
            Connection connection = driver.connect("jdbc:calcite:", new Properties());
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            rootSchema = calciteConnection.getRootSchema();
        }
        catch (SQLException e) {
            throw new SamzaException((Throwable)e);
        }
        ArrayList<Object> traitDefs = new ArrayList<Object>();
        traitDefs.add(ConventionTraitDef.INSTANCE);
        traitDefs.add(RelCollationTraitDef.INSTANCE);
        FrameworkConfig frameworkConfig = Frameworks.newConfigBuilder().parserConfig(SqlParser.configBuilder().setLex(Lex.JAVA).build()).defaultSchema(rootSchema).operatorTable((SqlOperatorTable)SqlStdOperatorTable.instance()).traitDefs(traitDefs).context((Context)Contexts.EMPTY_CONTEXT).costFactory(null).build();
        return Frameworks.getPlanner((FrameworkConfig)frameworkConfig);
    }

    private static ArrayList<String> getSourcesFromSelectQuery(SqlSelect sqlSelect) {
        ArrayList<String> sources = new ArrayList<String>();
        SamzaSqlQueryParser.getSource(sqlSelect.getFrom(), sources);
        if (sources.size() < 1) {
            throw new SamzaException("Unsupported query " + sqlSelect);
        }
        return sources;
    }

    private static void getSource(SqlNode node, ArrayList<String> sourceList) {
        if (node instanceof SqlJoin) {
            SqlJoin joinNode = (SqlJoin)node;
            ArrayList<String> sourcesLeft = new ArrayList<String>();
            ArrayList<String> sourcesRight = new ArrayList<String>();
            SamzaSqlQueryParser.getSource(joinNode.getLeft(), sourcesLeft);
            SamzaSqlQueryParser.getSource(joinNode.getRight(), sourcesRight);
            sourceList.addAll(sourcesLeft);
            sourceList.addAll(sourcesRight);
        } else if (node instanceof SqlIdentifier) {
            sourceList.add(node.toString());
        } else if (node instanceof SqlBasicCall) {
            SqlBasicCall basicCall = (SqlBasicCall)node;
            if (basicCall.getOperator() instanceof SqlAsOperator) {
                SamzaSqlQueryParser.getSource(basicCall.operand(0), sourceList);
            } else if (basicCall.getOperator() instanceof SqlUnnestOperator && basicCall.operand(0) instanceof SqlSelect) {
                sourceList.addAll(SamzaSqlQueryParser.getSourcesFromSelectQuery((SqlSelect)basicCall.operand(0)));
            }
        } else if (node instanceof SqlSelect) {
            SamzaSqlQueryParser.getSource(((SqlSelect)node).getFrom(), sourceList);
        }
    }

    public static class QueryInfo {
        private final List<String> sources;
        private String selectQuery;
        private String sink;
        private String sql;

        public QueryInfo(String selectQuery, List<String> sources, String sink, String sql) {
            this.selectQuery = selectQuery;
            this.sink = sink;
            this.sources = sources;
            this.sql = sql;
        }

        public List<String> getSources() {
            return this.sources;
        }

        public String getSelectQuery() {
            return this.selectQuery;
        }

        public String getSink() {
            return this.sink;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

