/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.testutil;

import java.lang.reflect.Constructor;
import java.util.stream.IntStream;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
    }

    public static <T> T createInstance(String clazz, Object ... args) {
        Validate.notNull((Object)clazz, (String)"null class name");
        try {
            Class<?> classObj = Class.forName(clazz);
            Class[] argTypes = new Class[args.length];
            IntStream.range(0, args.length).forEach(i -> {
                argTypes[i] = args[i].getClass();
            });
            Constructor<?> ctor = classObj.getDeclaredConstructor(argTypes);
            return (T)ctor.newInstance(args);
        }
        catch (Exception e) {
            LOG.warn("Failed to create instance for: " + clazz, (Throwable)e);
            return null;
        }
    }
}

