/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.testutil;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.Validate;
import org.apache.samza.SamzaException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger((String)JsonUtil.class.getName());

    private JsonUtil() {
    }

    public static <T> T fromJson(String json, TypeReference<T> typeRef) {
        Object object;
        Validate.notNull((Object)json, (String)"null JSON string");
        Validate.notNull(typeRef, (String)"null type reference");
        try {
            object = MAPPER.readValue(json, typeRef);
        }
        catch (IOException e) {
            String errorMessage = "Failed to parse json: " + json;
            LOG.error(errorMessage, (Throwable)e);
            throw new SamzaException(errorMessage, (Throwable)e);
        }
        return (T)object;
    }

    public static <T> String toJson(T object) {
        Validate.notNull(object, (String)"null input object");
        StringWriter out = new StringWriter();
        try {
            MAPPER.writeValue((Writer)out, object);
        }
        catch (IOException e) {
            String errorMessage = "Failed to serialize object: " + object;
            LOG.error(errorMessage, (Throwable)e);
            throw new SamzaException(errorMessage, (Throwable)e);
        }
        return out.toString();
    }

    static {
        MAPPER.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

