/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.runner;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.runtime.ApplicationRunner;
import org.apache.samza.runtime.ApplicationRunners;
import org.apache.samza.runtime.LocalApplicationRunner;
import org.apache.samza.runtime.RemoteApplicationRunner;
import org.apache.samza.sql.dsl.SamzaSqlDslConverter;
import org.apache.samza.sql.interfaces.SqlIOConfig;
import org.apache.samza.sql.interfaces.SqlIOResolver;
import org.apache.samza.sql.runner.SamzaSqlApplication;
import org.apache.samza.sql.runner.SamzaSqlApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaSqlApplicationRunner
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaSqlApplicationRunner.class);
    private final ApplicationRunner runner;
    public static final String RUNNER_CONFIG = "app.runner.class";
    public static final String CFG_FMT_SAMZA_STREAM_SYSTEM = "streams.%s.samza.system";

    public SamzaSqlApplicationRunner(SamzaApplication app, Config config) {
        this(app, false, config);
    }

    public SamzaSqlApplicationRunner(Boolean localRunner, Config config) {
        this((SamzaApplication)new SamzaSqlApplication(), localRunner, config);
    }

    private SamzaSqlApplicationRunner(SamzaApplication app, Boolean localRunner, Config config) {
        this.runner = ApplicationRunners.getApplicationRunner((SamzaApplication)app, (Config)SamzaSqlApplicationRunner.computeSamzaConfigs(localRunner, config));
    }

    public static Config computeSamzaConfigs(Boolean localRunner, Config config) {
        HashMap<String, String> newConfig = new HashMap<String, String>();
        List<String> dslStmts = SamzaSqlDslConverter.fetchSqlFromConfig((Map<String, String>)config);
        String sqlJson = SamzaSqlApplicationConfig.serializeSqlStmts(dslStmts);
        newConfig.put("samza.sql.stmts.json", sqlJson);
        HashSet<String> inputSystemStreams = new HashSet<String>();
        HashSet<String> outputSystemStreams = new HashSet<String>();
        SamzaSqlApplicationConfig.populateSystemStreamsAndGetRelRoots(dslStmts, config, inputSystemStreams, outputSystemStreams);
        SqlIOResolver ioResolver = SamzaSqlApplicationConfig.createIOResolver(config);
        for (String source : inputSystemStreams) {
            SqlIOConfig inputSystemStreamConfig = ioResolver.fetchSourceInfo(source);
            newConfig.put(String.format(CFG_FMT_SAMZA_STREAM_SYSTEM, inputSystemStreamConfig.getStreamName()), inputSystemStreamConfig.getSystemName());
            newConfig.putAll((Map<String, String>)inputSystemStreamConfig.getConfig());
        }
        for (String sink : outputSystemStreams) {
            SqlIOConfig outputSystemStreamConfig = ioResolver.fetchSinkInfo(sink);
            newConfig.put(String.format(CFG_FMT_SAMZA_STREAM_SYSTEM, outputSystemStreamConfig.getStreamName()), outputSystemStreamConfig.getSystemName());
            newConfig.putAll((Map<String, String>)outputSystemStreamConfig.getConfig());
        }
        newConfig.putAll((Map<String, String>)config);
        if (localRunner.booleanValue()) {
            newConfig.put(RUNNER_CONFIG, LocalApplicationRunner.class.getName());
        } else {
            newConfig.put(RUNNER_CONFIG, RemoteApplicationRunner.class.getName());
        }
        LOG.info("New Samza configs: " + newConfig);
        return new MapConfig(newConfig);
    }

    public void runAndWaitForFinish() {
        Validate.isTrue((boolean)(this.runner instanceof LocalApplicationRunner), (String)"This method can be called only in standalone mode.", (Object[])new Object[0]);
        this.run();
        this.waitForFinish();
    }

    public void run() {
        this.runner.run();
    }

    public void kill() {
        this.runner.kill();
    }

    public ApplicationStatus status() {
        return this.runner.status();
    }

    public void waitForFinish() {
        this.runner.waitForFinish();
    }

    public boolean waitForFinish(Duration timeout) {
        return this.runner.waitForFinish(timeout);
    }
}

