/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.runner;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.TableModify;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.sql.dsl.SamzaSqlDslConverter;
import org.apache.samza.sql.dsl.SamzaSqlDslConverterFactory;
import org.apache.samza.sql.impl.ConfigBasedUdfResolver;
import org.apache.samza.sql.interfaces.DslConverter;
import org.apache.samza.sql.interfaces.RelSchemaProvider;
import org.apache.samza.sql.interfaces.RelSchemaProviderFactory;
import org.apache.samza.sql.interfaces.SamzaRelConverter;
import org.apache.samza.sql.interfaces.SamzaRelConverterFactory;
import org.apache.samza.sql.interfaces.SqlIOConfig;
import org.apache.samza.sql.interfaces.SqlIOResolver;
import org.apache.samza.sql.interfaces.SqlIOResolverFactory;
import org.apache.samza.sql.interfaces.UdfMetadata;
import org.apache.samza.sql.interfaces.UdfResolver;
import org.apache.samza.sql.testutil.JsonUtil;
import org.apache.samza.sql.testutil.ReflectionUtils;
import org.apache.samza.sql.testutil.SamzaSqlQueryParser;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaSqlApplicationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaSqlApplicationConfig.class);
    public static final String CFG_SQL_STMT = "samza.sql.stmt";
    public static final String CFG_SQL_STMTS_JSON = "samza.sql.stmts.json";
    public static final String CFG_SQL_FILE = "samza.sql.sqlFile";
    public static final String CFG_UDF_CONFIG_DOMAIN = "samza.sql.udf";
    public static final String CFG_FACTORY = "factory";
    public static final String CFG_FMT_REL_SCHEMA_PROVIDER_DOMAIN = "samza.sql.relSchemaProvider.%s.";
    public static final String CFG_FMT_SAMZA_REL_CONVERTER_DOMAIN = "samza.sql.relConverter.%s.";
    public static final String CFG_IO_RESOLVER = "samza.sql.ioResolver";
    public static final String CFG_FMT_SOURCE_RESOLVER_DOMAIN = "samza.sql.ioResolver.%s.";
    public static final String CFG_UDF_RESOLVER = "samza.sql.udfResolver";
    public static final String CFG_FMT_UDF_RESOLVER_DOMAIN = "samza.sql.udfResolver.%s.";
    public static final String CFG_GROUPBY_WINDOW_DURATION_MS = "samza.sql.groupby.window.ms";
    public static final String SAMZA_SYSTEM_LOG = "log";
    private static final long DEFAULT_GROUPBY_WINDOW_DURATION_MS = 300000L;
    private final Map<String, RelSchemaProvider> relSchemaProvidersBySource;
    private final Map<String, SamzaRelConverter> samzaRelConvertersBySource;
    private SqlIOResolver ioResolver;
    private UdfResolver udfResolver;
    private final Collection<UdfMetadata> udfMetadata;
    private final Map<String, SqlIOConfig> inputSystemStreamConfigBySource;
    private final Map<String, SqlIOConfig> outputSystemStreamConfigsBySource;
    private final Map<String, SqlIOConfig> systemStreamConfigsBySource;
    private final long windowDurationMs;

    public SamzaSqlApplicationConfig(Config staticConfig, Set<String> inputSystemStreams, Set<String> outputSystemStreams) {
        this.ioResolver = SamzaSqlApplicationConfig.createIOResolver(staticConfig);
        this.inputSystemStreamConfigBySource = inputSystemStreams.stream().collect(Collectors.toMap(Function.identity(), src -> this.ioResolver.fetchSourceInfo((String)src)));
        this.outputSystemStreamConfigsBySource = outputSystemStreams.stream().collect(Collectors.toMap(Function.identity(), x -> this.ioResolver.fetchSinkInfo((String)x)));
        this.systemStreamConfigsBySource = new HashMap<String, SqlIOConfig>(this.inputSystemStreamConfigBySource);
        this.systemStreamConfigsBySource.putAll(this.outputSystemStreamConfigsBySource);
        HashSet<SqlIOConfig> systemStreamConfigs = new HashSet<SqlIOConfig>(this.systemStreamConfigsBySource.values());
        this.relSchemaProvidersBySource = systemStreamConfigs.stream().collect(Collectors.toMap(SqlIOConfig::getSource, x -> SamzaSqlApplicationConfig.initializePlugin("RelSchemaProvider", x.getRelSchemaProviderName(), staticConfig, CFG_FMT_REL_SCHEMA_PROVIDER_DOMAIN, (o, c) -> ((RelSchemaProviderFactory)o).create(x.getSystemStream(), (Config)c))));
        this.samzaRelConvertersBySource = systemStreamConfigs.stream().collect(Collectors.toMap(SqlIOConfig::getSource, x -> SamzaSqlApplicationConfig.initializePlugin("SamzaRelConverter", x.getSamzaRelConverterName(), staticConfig, CFG_FMT_SAMZA_REL_CONVERTER_DOMAIN, (o, c) -> ((SamzaRelConverterFactory)o).create(x.getSystemStream(), this.relSchemaProvidersBySource.get(x.getSource()), (Config)c))));
        this.udfResolver = this.createUdfResolver((Map<String, String>)staticConfig);
        this.udfMetadata = this.udfResolver.getUdfs();
        this.windowDurationMs = staticConfig.getLong(CFG_GROUPBY_WINDOW_DURATION_MS, 300000L);
        this.outputSystemStreamConfigsBySource.forEach((k, v) -> {
            if (k.split("\\.")[0].equals(SAMZA_SYSTEM_LOG)) {
                this.systemStreamConfigsBySource.remove(k);
            }
        });
    }

    public static <T> T initializePlugin(String pluginName, String plugin, Config staticConfig, String pluginDomainFormat, BiFunction<Object, Config, T> factoryInvoker) {
        String pluginDomain = String.format(pluginDomainFormat, plugin);
        Config pluginConfig = staticConfig.subset(pluginDomain);
        String factoryName = (String)pluginConfig.getOrDefault((Object)CFG_FACTORY, (Object)"");
        Validate.notEmpty((String)factoryName, (String)String.format("Factory is not set for %s", plugin));
        Object factory = ReflectionUtils.createInstance(factoryName, new Object[0]);
        Validate.notNull(factory, (String)String.format("Factory creation failed for %s", plugin));
        LOG.info("Instantiating {} using factory {} with props {}", new Object[]{pluginName, factoryName, pluginConfig});
        return factoryInvoker.apply(factory, pluginConfig);
    }

    public static List<String> deserializeSqlStmts(String value) {
        Validate.notEmpty((String)value, (String)"json Value is not set or empty");
        return JsonUtil.fromJson(value, new TypeReference<List<String>>(){});
    }

    public static String serializeSqlStmts(List<String> sqlStmts) {
        Validate.notEmpty(sqlStmts, (String)"json Value is not set or empty");
        return JsonUtil.toJson(sqlStmts);
    }

    public static SqlIOResolver createIOResolver(Config config) {
        String sourceResolveValue = (String)config.get((Object)CFG_IO_RESOLVER);
        Validate.notEmpty((String)sourceResolveValue, (String)"ioResolver config is not set or empty");
        return SamzaSqlApplicationConfig.initializePlugin("SqlIOResolver", sourceResolveValue, config, CFG_FMT_SOURCE_RESOLVER_DOMAIN, (o, c) -> ((SqlIOResolverFactory)o).create((Config)c, config));
    }

    private UdfResolver createUdfResolver(Map<String, String> config) {
        String udfResolveValue = config.get(CFG_UDF_RESOLVER);
        Validate.notEmpty((String)udfResolveValue, (String)"udfResolver config is not set or empty");
        HashMap<String, String> domainConfig = SamzaSqlApplicationConfig.getDomainProperties(config, String.format(CFG_FMT_UDF_RESOLVER_DOMAIN, udfResolveValue), false);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)domainConfig);
        HashMap<String, String> udfConfig = SamzaSqlApplicationConfig.getDomainProperties(config, CFG_UDF_CONFIG_DOMAIN, false);
        return new ConfigBasedUdfResolver(props, (Config)new MapConfig(udfConfig));
    }

    private static HashMap<String, String> getDomainProperties(Map<String, String> props, String prefix, boolean preserveFullKey) {
        String fullPrefix = StringUtils.isBlank((String)prefix) ? "" : (prefix.endsWith(".") ? prefix : prefix + ".");
        HashMap<String, String> ret = new HashMap<String, String>();
        props.keySet().forEach(keyStr -> {
            if (keyStr.startsWith(fullPrefix) && !keyStr.equals(fullPrefix)) {
                if (preserveFullKey) {
                    ret.put((String)keyStr, (String)props.get(keyStr));
                } else {
                    ret.put(keyStr.substring(fullPrefix.length()), (String)props.get(keyStr));
                }
            }
        });
        return ret;
    }

    public static Collection<RelRoot> populateSystemStreamsAndGetRelRoots(List<String> dslStmts, Config config, Set<String> inputSystemStreams, Set<String> outputSystemStreams) {
        SamzaSqlDslConverterFactory dslConverterFactory = new SamzaSqlDslConverterFactory();
        DslConverter dslConverter = dslConverterFactory.create(config);
        Collection<RelRoot> relRoots = dslConverter.convertDsl(String.join((CharSequence)"\n", dslStmts));
        List<String> sqlStmts = SamzaSqlDslConverter.fetchSqlFromConfig((Map<String, String>)config);
        List<SamzaSqlQueryParser.QueryInfo> queryInfo = SamzaSqlDslConverter.fetchQueryInfo(sqlStmts);
        inputSystemStreams.addAll(queryInfo.stream().map(SamzaSqlQueryParser.QueryInfo::getSources).flatMap(Collection::stream).collect(Collectors.toSet()));
        outputSystemStreams.addAll(queryInfo.stream().map(SamzaSqlQueryParser.QueryInfo::getSink).collect(Collectors.toSet()));
        return relRoots;
    }

    private static void populateSystemStreams(RelNode relNode, Set<String> inputSystemStreams, Set<String> outputSystemStreams) {
        if (relNode instanceof TableModify) {
            outputSystemStreams.add(SamzaSqlApplicationConfig.getSystemStreamName(relNode));
        } else if (relNode instanceof BiRel) {
            BiRel biRelNode = (BiRel)relNode;
            SamzaSqlApplicationConfig.populateSystemStreams(biRelNode.getLeft(), inputSystemStreams, outputSystemStreams);
            SamzaSqlApplicationConfig.populateSystemStreams(biRelNode.getRight(), inputSystemStreams, outputSystemStreams);
        } else if (relNode.getTable() != null) {
            inputSystemStreams.add(SamzaSqlApplicationConfig.getSystemStreamName(relNode));
        }
        List relNodes = relNode.getInputs();
        if (relNodes == null || relNodes.isEmpty()) {
            return;
        }
        relNodes.forEach(node -> SamzaSqlApplicationConfig.populateSystemStreams(node, inputSystemStreams, outputSystemStreams));
    }

    private static String getSystemStreamName(RelNode relNode) {
        return relNode.getTable().getQualifiedName().stream().map(Object::toString).collect(Collectors.joining("."));
    }

    public Collection<UdfMetadata> getUdfMetadata() {
        return this.udfMetadata;
    }

    public Map<String, SqlIOConfig> getInputSystemStreamConfigBySource() {
        return this.inputSystemStreamConfigBySource;
    }

    public Map<String, SqlIOConfig> getOutputSystemStreamConfigsBySource() {
        return this.outputSystemStreamConfigsBySource;
    }

    public Map<String, SqlIOConfig> getSystemStreamConfigsBySource() {
        return this.systemStreamConfigsBySource;
    }

    public Map<String, SamzaRelConverter> getSamzaRelConverters() {
        return this.samzaRelConvertersBySource;
    }

    public Map<String, RelSchemaProvider> getRelSchemaProviders() {
        return this.relSchemaProvidersBySource;
    }

    public SqlIOResolver getIoResolver() {
        return this.ioResolver;
    }

    public long getWindowDurationMs() {
        return this.windowDurationMs;
    }
}

