/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.runner;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.rel.RelRoot;
import org.apache.samza.application.StreamApplication;
import org.apache.samza.application.descriptors.StreamApplicationDescriptor;
import org.apache.samza.context.ApplicationTaskContextFactory;
import org.apache.samza.sql.data.SamzaSqlExecutionContext;
import org.apache.samza.sql.dsl.SamzaSqlDslConverter;
import org.apache.samza.sql.interfaces.SamzaRelConverter;
import org.apache.samza.sql.runner.SamzaSqlApplicationConfig;
import org.apache.samza.sql.runner.SamzaSqlApplicationContext;
import org.apache.samza.sql.translator.QueryTranslator;
import org.apache.samza.sql.translator.TranslatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaSqlApplication
implements StreamApplication {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaSqlApplication.class);
    private AtomicInteger queryId = new AtomicInteger(0);

    public void describe(StreamApplicationDescriptor appDescriptor) {
        try {
            List<String> dslStmts = SamzaSqlDslConverter.fetchSqlFromConfig((Map<String, String>)appDescriptor.getConfig());
            HashMap<Integer, TranslatorContext> translatorContextMap = new HashMap<Integer, TranslatorContext>();
            HashSet<String> inputSystemStreams = new HashSet<String>();
            HashSet<String> outputSystemStreams = new HashSet<String>();
            Collection<RelRoot> relRoots = SamzaSqlApplicationConfig.populateSystemStreamsAndGetRelRoots(dslStmts, appDescriptor.getConfig(), inputSystemStreams, outputSystemStreams);
            SamzaSqlApplicationConfig sqlConfig = new SamzaSqlApplicationConfig(appDescriptor.getConfig(), inputSystemStreams, outputSystemStreams);
            QueryTranslator queryTranslator = new QueryTranslator(appDescriptor, sqlConfig);
            SamzaSqlExecutionContext executionContext = new SamzaSqlExecutionContext(sqlConfig);
            Map<String, SamzaRelConverter> converters = sqlConfig.getSamzaRelConverters();
            for (RelRoot relRoot : relRoots) {
                LOG.info("Translating relRoot {} to samza stream graph", (Object)relRoot);
                int qId = this.queryId.incrementAndGet();
                TranslatorContext translatorContext = new TranslatorContext(appDescriptor, relRoot, executionContext, converters);
                translatorContextMap.put(qId, translatorContext);
                queryTranslator.translate(relRoot, translatorContext, qId);
            }
            appDescriptor.withApplicationTaskContextFactory((ApplicationTaskContextFactory & Serializable)(jobContext, containerContext, taskContext, applicationContainerContext) -> new SamzaSqlApplicationContext(translatorContextMap));
        }
        catch (RuntimeException e) {
            LOG.error("SamzaSqlApplication threw exception.", (Throwable)e);
            throw e;
        }
    }
}

