/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.planner;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.schema.Function;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.util.ListSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.samza.sql.planner.Checker;
import org.apache.samza.sql.planner.SamzaSqlScalarFunctionImpl;

public class SamzaSqlUdfOperatorTable
implements SqlOperatorTable {
    private final ListSqlOperatorTable operatorTable;

    public SamzaSqlUdfOperatorTable(List<SamzaSqlScalarFunctionImpl> scalarFunctions) {
        this.operatorTable = new ListSqlOperatorTable(this.getSqlOperators(scalarFunctions));
    }

    private List<SqlOperator> getSqlOperators(List<SamzaSqlScalarFunctionImpl> scalarFunctions) {
        return scalarFunctions.stream().map(this::getSqlOperator).collect(Collectors.toList());
    }

    private SqlOperator getSqlOperator(SamzaSqlScalarFunctionImpl scalarFunction) {
        return new SqlUserDefinedFunction(new SqlIdentifier(scalarFunction.getUdfName(), SqlParserPos.ZERO), o -> scalarFunction.getReturnType(o.getTypeFactory()), null, (SqlOperandTypeChecker)Checker.ANY_CHECKER, null, (Function)scalarFunction);
    }

    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        this.operatorTable.lookupOperatorOverloads(opName, category, syntax, operatorList);
    }

    public List<SqlOperator> getOperatorList() {
        return this.operatorTable.getOperatorList();
    }
}

