/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.planner;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.samza.sql.data.SamzaSqlExecutionContext;
import org.apache.samza.sql.udfs.ScalarUdf;

public class SamzaSqlScalarFunctionImpl
implements ScalarFunction,
ImplementableFunction {
    private final ScalarFunction myIncFunction;
    private final Method udfMethod;
    private final Method getUdfMethod;
    private final String udfName;

    public SamzaSqlScalarFunctionImpl(String udfName, Method udfMethod) {
        this.myIncFunction = ScalarFunctionImpl.create((Method)udfMethod);
        this.udfName = udfName;
        this.udfMethod = udfMethod;
        this.getUdfMethod = Arrays.stream(SamzaSqlExecutionContext.class.getMethods()).filter(x -> x.getName().equals("getOrCreateUdf")).findFirst().get();
    }

    public String getUdfName() {
        return this.udfName;
    }

    public CallImplementor getImplementor() {
        return RexImpTable.createImplementor((translator, call, translatedOperands) -> {
            ParameterExpression context = Expressions.parameter(SamzaSqlExecutionContext.class, (String)"context");
            MethodCallExpression getUdfInstance = Expressions.call(ScalarUdf.class, (Expression)context, (Method)this.getUdfMethod, (Expression[])new Expression[]{Expressions.constant((Object)this.udfMethod.getDeclaringClass().getName()), Expressions.constant((Object)this.udfName)});
            UnaryExpression callExpression = Expressions.convert_((Expression)Expressions.call((Expression)Expressions.convert_((Expression)getUdfInstance, this.udfMethod.getDeclaringClass()), (Method)this.udfMethod, (Iterable)translatedOperands), Object.class);
            return Expressions.convert_((Expression)callExpression, this.udfMethod.getReturnType());
        }, (NullPolicy)NullPolicy.NONE, (boolean)false);
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return this.myIncFunction.getReturnType(typeFactory);
    }

    public List<FunctionParameter> getParameters() {
        return this.myIncFunction.getParameters();
    }
}

