/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.planner;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.samza.SamzaException;
import org.apache.samza.sql.interfaces.RelSchemaProvider;
import org.apache.samza.sql.interfaces.SqlIOConfig;
import org.apache.samza.sql.interfaces.UdfMetadata;
import org.apache.samza.sql.planner.SamzaSqlOperatorTable;
import org.apache.samza.sql.planner.SamzaSqlScalarFunctionImpl;
import org.apache.samza.sql.planner.SamzaSqlUdfOperatorTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(QueryPlanner.class);
    private final Collection<UdfMetadata> udfMetadata;
    private final Map<String, RelSchemaProvider> relSchemaProviders;
    private final Map<String, SqlIOConfig> systemStreamConfigBySource;

    public QueryPlanner(Map<String, RelSchemaProvider> relSchemaProviders, Map<String, SqlIOConfig> systemStreamConfigBySource, Collection<UdfMetadata> udfMetadata) {
        this.relSchemaProviders = relSchemaProviders;
        this.systemStreamConfigBySource = systemStreamConfigBySource;
        this.udfMetadata = udfMetadata;
    }

    public RelRoot plan(String query) {
        try {
            Connection connection = DriverManager.getConnection("jdbc:calcite:");
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            block2: for (SqlIOConfig ssc : this.systemStreamConfigBySource.values()) {
                SchemaPlus previousLevelSchema = rootSchema;
                List<String> sourceParts = ssc.getSourceParts();
                RelSchemaProvider relSchemaProvider = this.relSchemaProviders.get(ssc.getSource());
                for (int sourcePartIndex = 0; sourcePartIndex < sourceParts.size(); ++sourcePartIndex) {
                    SchemaPlus sourcePartSchema;
                    String sourcePart = sourceParts.get(sourcePartIndex);
                    if (sourcePartIndex < sourceParts.size() - 1) {
                        sourcePartSchema = previousLevelSchema.getSubSchema(sourcePart);
                        if (sourcePartSchema == null) {
                            sourcePartSchema = previousLevelSchema.add(sourcePart, (Schema)new AbstractSchema());
                        }
                    } else {
                        RelDataType relationalSchema = relSchemaProvider.getRelationalSchema();
                        previousLevelSchema.add(sourcePart, this.createTableFromRelSchema(relationalSchema));
                        continue block2;
                    }
                    previousLevelSchema = sourcePartSchema;
                }
            }
            List<SamzaSqlScalarFunctionImpl> samzaSqlFunctions = this.udfMetadata.stream().map(x -> new SamzaSqlScalarFunctionImpl(x.getName(), x.getUdfMethod())).collect(Collectors.toList());
            ArrayList<Object> traitDefs = new ArrayList<Object>();
            traitDefs.add(ConventionTraitDef.INSTANCE);
            traitDefs.add(RelCollationTraitDef.INSTANCE);
            ArrayList<Object> sqlOperatorTables = new ArrayList<Object>();
            sqlOperatorTables.add((Object)new SamzaSqlOperatorTable());
            sqlOperatorTables.add(new SamzaSqlUdfOperatorTable(samzaSqlFunctions));
            FrameworkConfig frameworkConfig = Frameworks.newConfigBuilder().parserConfig(SqlParser.configBuilder().setLex(Lex.JAVA).build()).defaultSchema(rootSchema).operatorTable((SqlOperatorTable)new ChainedSqlOperatorTable(sqlOperatorTables)).traitDefs(traitDefs).context((Context)Contexts.EMPTY_CONTEXT).costFactory(null).build();
            Planner planner = Frameworks.getPlanner((FrameworkConfig)frameworkConfig);
            SqlNode sql = planner.parse(query);
            SqlNode validatedSql = planner.validate(sql);
            RelRoot relRoot = planner.rel(validatedSql);
            LOG.info("query plan:\n" + sql.toString());
            return relRoot;
        }
        catch (Exception e) {
            LOG.error("Query planner failed with exception.", (Throwable)e);
            throw new SamzaException((Throwable)e);
        }
    }

    private Table createTableFromRelSchema(final RelDataType relationalSchema) {
        return new AbstractTable(){

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                ArrayList<RelDataTypeFieldImpl> fieldsList = new ArrayList<RelDataTypeFieldImpl>();
                fieldsList.add(new RelDataTypeFieldImpl("__key__", 0, typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.VARCHAR), true)));
                fieldsList.addAll(relationalSchema.getFieldList());
                return new RelRecordType(fieldsList);
            }
        };
    }
}

