/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.planner;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.commons.lang3.tuple.Pair;

class Checker
implements SqlOperandTypeChecker {
    private SqlOperandCountRange range;
    public static final Checker ANY_CHECKER = new Checker();
    private static final Map<Pair<Integer, Integer>, Checker> checkerMap = Maps.newHashMap();

    public static Checker getChecker(int min, int max) {
        Pair range = Pair.of((Object)min, (Object)max);
        if (checkerMap.containsKey(range)) {
            return checkerMap.get(range);
        }
        Checker newChecker = min == max ? new Checker(min) : new Checker(min, max);
        checkerMap.put((Pair<Integer, Integer>)range, newChecker);
        return newChecker;
    }

    private Checker(int size) {
        this.range = SqlOperandCountRanges.of((int)size);
    }

    private Checker(int min, int max) {
        this.range = SqlOperandCountRanges.between((int)min, (int)max);
    }

    private Checker() {
        this.range = SqlOperandCountRanges.any();
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return this.range;
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        return opName + "(Drill - Opaque)";
    }

    public SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    public boolean isOptional(int i) {
        return false;
    }
}

