/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.interfaces;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.config.StreamConfig;
import org.apache.samza.system.SystemStream;
import org.apache.samza.table.descriptors.TableDescriptor;

public class SqlIOConfig {
    public static final String CFG_SAMZA_REL_CONVERTER = "samzaRelConverterName";
    public static final String CFG_REL_SCHEMA_PROVIDER = "relSchemaProviderName";
    private final String systemName;
    private final String streamName;
    private final String samzaRelConverterName;
    private final SystemStream systemStream;
    private final String source;
    private final String relSchemaProviderName;
    private final Config config;
    private final List<String> sourceParts;
    private final Optional<TableDescriptor> tableDescriptor;

    public SqlIOConfig(String systemName, String streamName, Config systemConfig) {
        this(systemName, streamName, Arrays.asList(systemName, streamName), systemConfig, null);
    }

    public SqlIOConfig(String systemName, String streamName, Config systemConfig, TableDescriptor tableDescriptor) {
        this(systemName, streamName, Arrays.asList(systemName, streamName), systemConfig, tableDescriptor);
    }

    public SqlIOConfig(String systemName, String streamName, List<String> sourceParts, Config systemConfig, TableDescriptor tableDescriptor) {
        HashMap<String, String> streamConfigs = new HashMap<String, String>((Map<String, String>)systemConfig);
        this.systemName = systemName;
        this.streamName = streamName;
        this.source = SqlIOConfig.getSourceFromSourceParts(sourceParts);
        this.sourceParts = sourceParts;
        this.systemStream = new SystemStream(systemName, streamName);
        this.tableDescriptor = Optional.ofNullable(tableDescriptor);
        this.samzaRelConverterName = (String)streamConfigs.get(CFG_SAMZA_REL_CONVERTER);
        Validate.notEmpty((String)this.samzaRelConverterName, (String)String.format("%s is not set or empty for system %s", CFG_SAMZA_REL_CONVERTER, systemName));
        this.relSchemaProviderName = (String)streamConfigs.get(CFG_REL_SCHEMA_PROVIDER);
        streamConfigs.remove(CFG_SAMZA_REL_CONVERTER);
        streamConfigs.remove(CFG_REL_SCHEMA_PROVIDER);
        if (tableDescriptor != null) {
            streamConfigs.put(String.format(StreamConfig.BOOTSTRAP_FOR_STREAM_ID(), streamName), "true");
            streamConfigs.put(String.format(StreamConfig.CONSUMER_OFFSET_DEFAULT_FOR_STREAM_ID(), streamName), "oldest");
        }
        this.config = new MapConfig(streamConfigs);
    }

    public static String getSourceFromSourceParts(List<String> sourceParts) {
        return Joiner.on((String)".").join(sourceParts);
    }

    public List<String> getSourceParts() {
        return this.sourceParts;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getSamzaRelConverterName() {
        return this.samzaRelConverterName;
    }

    public String getRelSchemaProviderName() {
        return this.relSchemaProviderName;
    }

    public SystemStream getSystemStream() {
        return this.systemStream;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getSource() {
        return this.source;
    }

    public Optional<TableDescriptor> getTableDescriptor() {
        return this.tableDescriptor;
    }
}

