/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.sql.interfaces.UdfMetadata;
import org.apache.samza.sql.interfaces.UdfResolver;
import org.apache.samza.sql.udfs.ScalarUdf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBasedUdfResolver
implements UdfResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigBasedUdfResolver.class);
    public static final String CFG_UDF_CLASSES = "udfClasses";
    public static final String UDF_METHOD_NAME = "execute";
    private final ArrayList<UdfMetadata> udfs;

    public ConfigBasedUdfResolver(Properties config, Config udfConfig) {
        List udfClasses = Arrays.stream(config.getProperty(CFG_UDF_CLASSES, "").split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.udfs = new ArrayList();
        for (String udfClassName : udfClasses) {
            Method udfMethod;
            Class<?> udfClass;
            try {
                udfClass = Class.forName(udfClassName);
            }
            catch (ClassNotFoundException e) {
                String msg = String.format("Couldn't load the udf class %s", udfClassName);
                LOG.error(msg, (Throwable)e);
                throw new SamzaException(msg, (Throwable)e);
            }
            if (!ScalarUdf.class.isAssignableFrom(udfClass)) {
                String msg = String.format("Udf class %s is not extended from %s", udfClassName, ScalarUdf.class.getName());
                LOG.error(msg);
                throw new SamzaException(msg);
            }
            try {
                udfMethod = udfClass.getMethod(UDF_METHOD_NAME, Object[].class);
            }
            catch (NoSuchMethodException e) {
                String msg = String.format("Udf Class %s doesn't implement method named %s", udfClassName, UDF_METHOD_NAME);
                LOG.error(msg);
                throw new SamzaException(msg, (Throwable)e);
            }
            int udfIndex = udfClass.getSimpleName().toLowerCase().lastIndexOf("udf");
            String udfName = udfClass.getSimpleName().substring(0, udfIndex);
            this.udfs.add(new UdfMetadata(udfName, udfMethod, udfConfig.subset(udfName + ".")));
        }
    }

    @Override
    public Collection<UdfMetadata> getUdfs() {
        return this.udfs;
    }
}

