/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.impl;

import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.serializers.JsonSerdeV2;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.sql.data.SamzaSqlCompositeKey;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.interfaces.SqlIOConfig;
import org.apache.samza.sql.interfaces.SqlIOResolver;
import org.apache.samza.sql.interfaces.SqlIOResolverFactory;
import org.apache.samza.storage.kv.descriptors.RocksDbTableDescriptor;
import org.apache.samza.table.descriptors.TableDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBasedIOResolverFactory
implements SqlIOResolverFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigBasedIOResolverFactory.class);
    public static final String CFG_FMT_SAMZA_PREFIX = "systems.%s.";

    @Override
    public SqlIOResolver create(Config resolverConfig, Config fullConfig) {
        return new ConfigBasedIOResolver(resolverConfig);
    }

    private class ConfigBasedIOResolver
    implements SqlIOResolver {
        private final String SAMZA_SQL_QUERY_TABLE_KEYWORD = "$table";
        private final Config config;

        public ConfigBasedIOResolver(Config config) {
            this.config = config;
        }

        @Override
        public SqlIOConfig fetchSourceInfo(String source) {
            return this.fetchSystemInfo(source);
        }

        private SqlIOConfig fetchSystemInfo(String name) {
            String[] sourceComponents = name.split("\\.");
            boolean isTable = this.isTable(sourceComponents);
            int endIdx = sourceComponents.length - 1;
            int streamIdx = isTable ? endIdx - 1 : endIdx;
            boolean invalidQuery = false;
            if (sourceComponents.length != 2) {
                if (sourceComponents.length != 3 || !sourceComponents[endIdx].equalsIgnoreCase("$table")) {
                    invalidQuery = true;
                }
            } else if (sourceComponents[0].equalsIgnoreCase("$table") || sourceComponents[1].equalsIgnoreCase("$table")) {
                invalidQuery = true;
            }
            if (invalidQuery) {
                String msg = String.format("Source %s is not of the format {systemName}.{streamName}[.%s]", name, "$table");
                LOG.error(msg);
                throw new SamzaException(msg);
            }
            String systemName = sourceComponents[0];
            String streamName = sourceComponents[streamIdx];
            RocksDbTableDescriptor tableDescriptor = null;
            if (isTable) {
                tableDescriptor = new RocksDbTableDescriptor("InputTable-" + name, KVSerde.of((Serde)new JsonSerdeV2(SamzaSqlCompositeKey.class), (Serde)new JsonSerdeV2(SamzaSqlRelMessage.class)));
            }
            return new SqlIOConfig(systemName, streamName, this.fetchSystemConfigs(systemName), (TableDescriptor)tableDescriptor);
        }

        @Override
        public SqlIOConfig fetchSinkInfo(String sink) {
            return this.fetchSystemInfo(sink);
        }

        private boolean isTable(String[] sourceComponents) {
            return sourceComponents[sourceComponents.length - 1].equalsIgnoreCase("$table");
        }

        private Config fetchSystemConfigs(String systemName) {
            return this.config.subset(systemName + ".");
        }
    }
}

