/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.dsl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelRoot;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.sql.interfaces.DslConverter;
import org.apache.samza.sql.planner.QueryPlanner;
import org.apache.samza.sql.runner.SamzaSqlApplicationConfig;
import org.apache.samza.sql.testutil.SamzaSqlQueryParser;
import org.apache.samza.sql.testutil.SqlFileParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamzaSqlDslConverter
implements DslConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SamzaSqlDslConverter.class);
    private final Config config;

    SamzaSqlDslConverter(Config config) {
        this.config = config;
    }

    @Override
    public Collection<RelRoot> convertDsl(String dsl) {
        List<String> sqlStmts = SamzaSqlDslConverter.fetchSqlFromConfig((Map<String, String>)this.config);
        List<SamzaSqlQueryParser.QueryInfo> queryInfo = SamzaSqlDslConverter.fetchQueryInfo(sqlStmts);
        SamzaSqlApplicationConfig sqlConfig = new SamzaSqlApplicationConfig(this.config, queryInfo.stream().map(SamzaSqlQueryParser.QueryInfo::getSources).flatMap(Collection::stream).collect(Collectors.toSet()), queryInfo.stream().map(SamzaSqlQueryParser.QueryInfo::getSink).collect(Collectors.toSet()));
        QueryPlanner planner = new QueryPlanner(sqlConfig.getRelSchemaProviders(), sqlConfig.getSystemStreamConfigsBySource(), sqlConfig.getUdfMetadata());
        LinkedList<RelRoot> relRoots = new LinkedList<RelRoot>();
        for (String sql : sqlStmts) {
            SamzaSqlQueryParser.QueryInfo qinfo = SamzaSqlQueryParser.parseQuery(sql);
            if (qinfo.getSink().split("\\.")[0].equals("log")) {
                sql = qinfo.getSelectQuery();
            }
            relRoots.add(planner.plan(sql));
        }
        return relRoots;
    }

    public static List<SamzaSqlQueryParser.QueryInfo> fetchQueryInfo(List<String> sqlStmts) {
        return sqlStmts.stream().map(SamzaSqlQueryParser::parseQuery).collect(Collectors.toList());
    }

    public static List<String> fetchSqlFromConfig(Map<String, String> config) {
        List<String> sql;
        if (config.containsKey("samza.sql.stmt") && StringUtils.isNotBlank((CharSequence)config.get("samza.sql.stmt"))) {
            String sqlValue = config.get("samza.sql.stmt");
            sql = Collections.singletonList(sqlValue);
        } else if (config.containsKey("samza.sql.stmts.json") && StringUtils.isNotBlank((CharSequence)config.get("samza.sql.stmts.json"))) {
            sql = SamzaSqlApplicationConfig.deserializeSqlStmts(config.get("samza.sql.stmts.json"));
        } else if (config.containsKey("samza.sql.sqlFile")) {
            String sqlFile = config.get("samza.sql.sqlFile");
            sql = SqlFileParser.parseSqlFile(sqlFile);
        } else {
            String msg = "Config doesn't contain the SQL that needs to be executed.";
            LOG.error(msg);
            throw new SamzaException(msg);
        }
        return sql;
    }
}

