/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.sql.interfaces.UdfMetadata;
import org.apache.samza.sql.runner.SamzaSqlApplicationConfig;
import org.apache.samza.sql.testutil.ReflectionUtils;
import org.apache.samza.sql.udfs.ScalarUdf;

public class SamzaSqlExecutionContext
implements Cloneable {
    private final SamzaSqlApplicationConfig sqlConfig;
    private final Map<String, UdfMetadata> udfMetadata;
    private final Map<String, ScalarUdf> udfInstances = new HashMap<String, ScalarUdf>();

    private SamzaSqlExecutionContext(SamzaSqlExecutionContext other) {
        this.sqlConfig = other.sqlConfig;
        this.udfMetadata = other.udfMetadata;
    }

    public SamzaSqlExecutionContext(SamzaSqlApplicationConfig config) {
        this.sqlConfig = config;
        this.udfMetadata = this.sqlConfig.getUdfMetadata().stream().collect(Collectors.toMap(UdfMetadata::getName, Function.identity()));
    }

    public ScalarUdf getOrCreateUdf(String clazz, String udfName) {
        return this.udfInstances.computeIfAbsent(udfName, s -> this.createInstance(clazz, udfName));
    }

    public ScalarUdf createInstance(String clazz, String udfName) {
        Config udfConfig = this.udfMetadata.get(udfName).getUdfConfig();
        ScalarUdf scalarUdf = (ScalarUdf)ReflectionUtils.createInstance(clazz, new Object[0]);
        if (scalarUdf == null) {
            String msg = String.format("Couldn't create udf %s of class %s", udfName, clazz);
            throw new SamzaException(msg);
        }
        scalarUdf.init(udfConfig);
        return scalarUdf;
    }

    public SamzaSqlApplicationConfig getSamzaSqlApplicationConfig() {
        return this.sqlConfig;
    }

    public SamzaSqlExecutionContext clone() {
        return new SamzaSqlExecutionContext(this);
    }
}

