/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.util.Pair;
import org.apache.samza.SamzaException;
import org.apache.samza.sql.data.Expression;
import org.apache.samza.sql.data.SamzaSqlExecutionContext;
import org.apache.samza.sql.interfaces.SamzaSqlJavaTypeFactoryImpl;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexToJavaCompiler {
    private static final Logger log = LoggerFactory.getLogger(RexToJavaCompiler.class);
    private final RexBuilder rexBuilder;

    public RexToJavaCompiler(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    public Expression compile(List<RelNode> inputs, List<RexNode> nodes) {
        RelDataTypeFactory.FieldInfoBuilder fieldBuilder = this.rexBuilder.getTypeFactory().builder();
        for (RelNode input : inputs) {
            fieldBuilder.addAll((Iterable)input.getRowType().getFieldList());
        }
        RelDataType inputRowType = fieldBuilder.build();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        for (RexNode node : nodes) {
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression executionContext = Expressions.parameter(SamzaSqlExecutionContext.class, (String)"context");
        ParameterExpression root = DataContext.ROOT;
        ParameterExpression inputValues = Expressions.parameter(Object[].class, (String)"inputValues");
        ParameterExpression outputValues = Expressions.parameter(Object[].class, (String)"outputValues");
        SamzaSqlJavaTypeFactoryImpl javaTypeFactory = new SamzaSqlJavaTypeFactoryImpl(this.rexBuilder.getTypeFactory().getTypeSystem());
        RexToLixTranslator.InputGetterImpl inputGetter = new RexToLixTranslator.InputGetterImpl((List)ImmutableList.of((Object)Pair.of((Object)Expressions.variable(Object[].class, (String)"inputValues"), (Object)PhysTypeImpl.of((JavaTypeFactory)javaTypeFactory, (RelDataType)inputRowType, (JavaRowFormat)JavaRowFormat.ARRAY, (boolean)false))));
        List list = RexToLixTranslator.translateProjects((RexProgram)program, (JavaTypeFactory)javaTypeFactory, (BlockBuilder)builder, null, (org.apache.calcite.linq4j.tree.Expression)DataContext.ROOT, (RexToLixTranslator.InputGetter)inputGetter, null);
        for (int i = 0; i < list.size(); ++i) {
            builder.add(Expressions.statement((org.apache.calcite.linq4j.tree.Expression)Expressions.assign((org.apache.calcite.linq4j.tree.Expression)Expressions.arrayIndex((org.apache.calcite.linq4j.tree.Expression)outputValues, (org.apache.calcite.linq4j.tree.Expression)Expressions.constant((Object)i)), (org.apache.calcite.linq4j.tree.Expression)((org.apache.calcite.linq4j.tree.Expression)list.get(i)))));
        }
        return RexToJavaCompiler.createSamzaExpressionFromCalcite(executionContext, root, inputValues, outputValues, builder.toBlock());
    }

    static Expression createSamzaExpressionFromCalcite(ParameterExpression executionContext, ParameterExpression dataContext, ParameterExpression inputValues, ParameterExpression outputValues, BlockStatement block) {
        ArrayList declarations = Lists.newArrayList();
        declarations.add(Expressions.methodDecl((int)1, Void.TYPE, (String)SamzaBuiltInMethod.EXPR_EXECUTE2.method.getName(), (Iterable)ImmutableList.of((Object)executionContext, (Object)dataContext, (Object)inputValues, (Object)outputValues), (BlockStatement)block));
        ClassDeclaration classDeclaration = Expressions.classDecl((int)1, (String)"SqlExpression", null, (List)ImmutableList.of(Expression.class), (List)declarations);
        String s = Expressions.toString((List)declarations, (String)"\n", (boolean)false);
        log.info("Generated code for expression: {}", (Object)s);
        try {
            return RexToJavaCompiler.getExpression(classDeclaration, s);
        }
        catch (Exception e) {
            throw new SamzaException("Expression compilation failure.", (Throwable)e);
        }
    }

    static Expression getExpression(ClassDeclaration expr, String s) throws CompileException, IOException {
        ICompilerFactory compilerFactory;
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setImplementedInterfaces(expr.implemented.toArray(new Class[expr.implemented.size()]));
        cbe.setParentClassLoader(RexToJavaCompiler.class.getClassLoader());
        cbe.setDebuggingInformation(true, true, true);
        return (Expression)cbe.createInstance((Reader)new StringReader(s));
    }

    public static enum SamzaBuiltInMethod {
        EXPR_EXECUTE2(Expression.class, "execute", SamzaSqlExecutionContext.class, DataContext.class, Object[].class, Object[].class);

        public final Method method;

        private SamzaBuiltInMethod(Class clazz, String methodName, Class ... argumentTypes) {
            this.method = Types.lookupMethod((Class)clazz, (String)methodName, (Class[])argumentTypes);
        }
    }
}

