/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.avro;

import org.apache.avro.Schema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.samza.config.Config;
import org.apache.samza.sql.avro.AvroRelSchemaProvider;
import org.apache.samza.sql.avro.AvroTypeFactoryImpl;
import org.apache.samza.sql.interfaces.RelSchemaProvider;
import org.apache.samza.sql.interfaces.RelSchemaProviderFactory;
import org.apache.samza.system.SystemStream;

public class ConfigBasedAvroRelSchemaProviderFactory
implements RelSchemaProviderFactory {
    public static final String CFG_SOURCE_SCHEMA = "%s.%s.schema";

    @Override
    public RelSchemaProvider create(SystemStream systemStream, Config config) {
        return new ConfigBasedAvroRelSchemaProvider(systemStream, config);
    }

    public static class ConfigBasedAvroRelSchemaProvider
    implements AvroRelSchemaProvider {
        private final Config config;
        private final SystemStream systemStream;

        public ConfigBasedAvroRelSchemaProvider(SystemStream systemStream, Config config) {
            this.systemStream = systemStream;
            this.config = config;
        }

        @Override
        public RelDataType getRelationalSchema() {
            String schemaStr = this.getSchema(this.systemStream);
            Schema schema = Schema.parse((String)schemaStr);
            AvroTypeFactoryImpl avroTypeFactory = new AvroTypeFactoryImpl();
            return avroTypeFactory.createType(schema);
        }

        @Override
        public String getSchema(SystemStream systemStream) {
            return (String)this.config.get((Object)String.format(ConfigBasedAvroRelSchemaProviderFactory.CFG_SOURCE_SCHEMA, systemStream.getSystem(), systemStream.getStream()));
        }
    }
}

