/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.avro;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.samza.SamzaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroTypeFactoryImpl
extends SqlTypeFactoryImpl {
    private static final Logger LOG = LoggerFactory.getLogger(AvroTypeFactoryImpl.class);

    public AvroTypeFactoryImpl() {
        super(RelDataTypeSystem.DEFAULT);
    }

    public RelDataType createType(Schema schema) {
        Schema.Type type = schema.getType();
        if (type != Schema.Type.RECORD) {
            String msg = String.format("System supports only RECORD as top level avro type, But the Schema's type is %s", type);
            LOG.error(msg);
            throw new SamzaException(msg);
        }
        return this.convertRecordType(schema);
    }

    private RelDataType convertRecordType(Schema schema) {
        List<RelDataTypeField> relFields = this.getRelFields(schema.getFields());
        return new RelRecordType(relFields);
    }

    private List<RelDataTypeField> getRelFields(List<Schema.Field> fields) {
        ArrayList<RelDataTypeField> relFields = new ArrayList<RelDataTypeField>();
        for (Schema.Field field : fields) {
            String fieldName = field.name();
            int fieldPos = field.pos() + 1;
            RelDataType dataType = this.getRelDataType(field.schema());
            relFields.add((RelDataTypeField)new RelDataTypeFieldImpl(fieldName, fieldPos, dataType));
        }
        return relFields;
    }

    private RelDataType getRelDataType(Schema fieldSchema) {
        switch (fieldSchema.getType()) {
            case ARRAY: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), true);
            }
            case BOOLEAN: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.BOOLEAN), true);
            }
            case DOUBLE: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.DOUBLE), true);
            }
            case FLOAT: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.FLOAT), true);
            }
            case ENUM: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.VARCHAR), true);
            }
            case UNION: {
                return this.getRelTypeFromUnionTypes(fieldSchema.getTypes());
            }
            case FIXED: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.VARBINARY), true);
            }
            case STRING: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.VARCHAR), true);
            }
            case BYTES: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.VARBINARY), true);
            }
            case INT: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.INTEGER), true);
            }
            case LONG: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.BIGINT), true);
            }
            case RECORD: {
                return this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), true);
            }
            case MAP: {
                return super.createMapType(this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), true), this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), true));
            }
        }
        String msg = String.format("Field Type %s is not supported", fieldSchema.getType());
        LOG.error(msg);
        throw new SamzaException(msg);
    }

    private RelDataType getRelTypeFromUnionTypes(List<Schema> types) {
        if (types.size() == 2) {
            if (types.get(0).getType() == Schema.Type.NULL) {
                return this.getRelDataType(types.get(1));
            }
            if (types.get(1).getType() == Schema.Type.NULL) {
                return this.getRelDataType(types.get(0));
            }
        }
        return this.createTypeWithNullability(this.createSqlType(SqlTypeName.VARCHAR), true);
    }
}

