/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.avro;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.operators.KV;
import org.apache.samza.sql.SamzaSqlRelRecord;
import org.apache.samza.sql.avro.AvroRelSchemaProvider;
import org.apache.samza.sql.data.SamzaSqlRelMessage;
import org.apache.samza.sql.interfaces.SamzaRelConverter;
import org.apache.samza.system.SystemStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroRelConverter
implements SamzaRelConverter {
    protected final Config config;
    private final Schema avroSchema;
    private static final Logger LOG = LoggerFactory.getLogger(AvroRelConverter.class);

    public AvroRelConverter(SystemStream systemStream, AvroRelSchemaProvider schemaProvider, Config config) {
        this.config = config;
        this.avroSchema = Schema.parse((String)schemaProvider.getSchema(systemStream));
    }

    @Override
    public SamzaSqlRelMessage convertToRelMessage(KV<Object, Object> samzaMessage) {
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        Object value = samzaMessage.getValue();
        if (value instanceof IndexedRecord) {
            IndexedRecord record = (IndexedRecord)value;
            Schema recordSchema = record.getSchema();
            fieldNames.addAll(this.avroSchema.getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
            fieldValues.addAll(fieldNames.stream().map(f -> this.convertToJavaObject(recordSchema.getField(f) != null ? record.get(recordSchema.getField(f).pos()) : null, this.getNonNullUnionSchema(this.avroSchema.getField(f).schema()))).collect(Collectors.toList()));
        } else if (value == null) {
            fieldNames.addAll(this.avroSchema.getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
            IntStream.range(0, fieldNames.size()).forEach(x -> fieldValues.add(null));
        } else {
            String msg = "Avro message converter doesn't support messages of type " + value.getClass();
            LOG.error(msg);
            throw new SamzaException(msg);
        }
        return new SamzaSqlRelMessage(samzaMessage.getKey(), fieldNames, fieldValues);
    }

    private SamzaSqlRelRecord convertToRelRecord(IndexedRecord avroRecord) {
        ArrayList values = new ArrayList();
        ArrayList fieldNames = new ArrayList();
        if (avroRecord == null) {
            String msg = "Avro Record is null";
            LOG.error(msg);
            throw new SamzaException(msg);
        }
        fieldNames.addAll(avroRecord.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
        values.addAll(avroRecord.getSchema().getFields().stream().map(f -> this.convertToJavaObject(avroRecord.get(avroRecord.getSchema().getField(f.name()).pos()), this.getNonNullUnionSchema(avroRecord.getSchema().getField(f.name()).schema()))).collect(Collectors.toList()));
        return new SamzaSqlRelRecord(fieldNames, values);
    }

    @Override
    public KV<Object, Object> convertToSamzaMessage(SamzaSqlRelMessage relMessage) {
        return this.convertToSamzaMessage(relMessage, this.avroSchema);
    }

    protected KV<Object, Object> convertToSamzaMessage(SamzaSqlRelMessage relMessage, Schema avroSchema) {
        return new KV(relMessage.getKey(), (Object)this.convertToGenericRecord(relMessage.getSamzaSqlRelRecord(), avroSchema));
    }

    private GenericRecord convertToGenericRecord(SamzaSqlRelRecord relRecord, Schema schema) {
        GenericData.Record record = new GenericData.Record(schema);
        List fieldNames = relRecord.getFieldNames();
        List values = relRecord.getFieldValues();
        for (int index = 0; index < fieldNames.size(); ++index) {
            if (((String)fieldNames.get(index)).equalsIgnoreCase("__key__")) continue;
            Object relObj = values.get(index);
            String fieldName = (String)fieldNames.get(index);
            Schema fieldSchema = schema.getField(fieldName).schema();
            record.put(fieldName, this.convertToAvroObject(relObj, this.getNonNullUnionSchema(fieldSchema)));
        }
        return record;
    }

    public Object convertToAvroObject(Object relObj, Schema schema) {
        if (relObj == null) {
            return null;
        }
        switch (schema.getType()) {
            case RECORD: {
                return this.convertToGenericRecord((SamzaSqlRelRecord)relObj, this.getNonNullUnionSchema(schema));
            }
            case ARRAY: {
                List avroList = ((List)relObj).stream().map(o -> this.convertToAvroObject(o, this.getNonNullUnionSchema(schema).getElementType())).collect(Collectors.toList());
                return avroList;
            }
            case MAP: {
                return ((Map)relObj).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convertToAvroObject(e.getValue(), this.getNonNullUnionSchema(schema).getValueType())));
            }
            case UNION: {
                return this.convertToAvroObject(relObj, this.getNonNullUnionSchema(schema));
            }
            case ENUM: {
                return new GenericData.EnumSymbol(schema, (String)relObj);
            }
            case FIXED: {
                return new GenericData.Fixed(schema, ((ByteString)relObj).getBytes());
            }
            case BYTES: {
                return ByteBuffer.wrap(((ByteString)relObj).getBytes());
            }
        }
        return relObj;
    }

    public Object convertToJavaObject(Object avroObj, Schema schema) {
        if (avroObj == null) {
            return null;
        }
        switch (schema.getType()) {
            case RECORD: {
                return this.convertToRelRecord((IndexedRecord)avroObj);
            }
            case ARRAY: {
                Object avroArray;
                ArrayList retVal = new ArrayList();
                if (avroObj instanceof GenericData.Array) {
                    avroArray = (GenericData.Array)avroObj;
                } else if (avroObj instanceof List) {
                    avroArray = (List)avroObj;
                } else {
                    throw new SamzaException("Unsupported array type " + avroObj.getClass().getSimpleName());
                }
                retVal.addAll(avroArray.stream().map(v -> this.convertToJavaObject(v, this.getNonNullUnionSchema(schema).getElementType())).collect(Collectors.toList()));
                return retVal;
            }
            case MAP: {
                HashMap<String, Object> retVal = new HashMap<String, Object>();
                retVal.putAll(((Map)avroObj).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convertToJavaObject(e.getValue(), this.getNonNullUnionSchema(schema).getValueType()))));
                return retVal;
            }
            case UNION: {
                return this.convertToJavaObject(avroObj, this.getNonNullUnionSchema(schema));
            }
            case ENUM: {
                return avroObj.toString();
            }
            case FIXED: {
                GenericData.Fixed fixed = (GenericData.Fixed)avroObj;
                return new ByteString(fixed.bytes());
            }
            case BYTES: {
                return new ByteString(((ByteBuffer)avroObj).array());
            }
        }
        return avroObj;
    }

    public Schema getNonNullUnionSchema(Schema schema) {
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            if (((Schema)schema.getTypes().get(0)).getType() != Schema.Type.NULL) {
                return (Schema)schema.getTypes().get(0);
            }
            if (((Schema)schema.getTypes().get(1)).getType() != Schema.Type.NULL) {
                return (Schema)schema.getTypes().get(1);
            }
        }
        return schema;
    }
}

