/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.ScopeChild;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public abstract class ListScope
extends DelegatingScope {
    public final List<ScopeChild> children = new ArrayList<ScopeChild>();

    public ListScope(SqlValidatorScope parent) {
        super(parent);
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias, boolean nullable) {
        Preconditions.checkNotNull((Object)alias);
        this.children.add(new ScopeChild(this.children.size(), alias, ns, nullable));
    }

    public List<SqlValidatorNamespace> getChildren() {
        return Lists.transform(this.children, ScopeChild.NAMESPACE_FN);
    }

    List<String> getChildNames() {
        return Lists.transform(this.children, ScopeChild.NAME_FN);
    }

    private ScopeChild findChild(List<String> names, SqlNameMatcher nameMatcher) {
        for (ScopeChild child : this.children) {
            SqlValidatorTable table;
            String lastName = Util.last(names);
            if (child.name != null) {
                if (!nameMatcher.matches(child.name, lastName)) continue;
                if (names.size() == 1) {
                    return child;
                }
            }
            if ((table = child.namespace.getTable()) == null) continue;
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            this.resolveTable(names, nameMatcher, SqlValidatorScope.Path.EMPTY, resolved);
            if (resolved.count() != 1 || !resolved.only().remainingNames.isEmpty() || !(resolved.only().namespace instanceof TableNamespace) || !resolved.only().namespace.getTable().getQualifiedName().equals(table.getQualifiedName())) continue;
            return child;
        }
        return null;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        for (ScopeChild child : this.children) {
            this.addColumnNames(child.namespace, result);
        }
        this.parent.findAllColumnNames(result);
    }

    @Override
    public void findAliases(Collection<SqlMoniker> result) {
        for (ScopeChild child : this.children) {
            result.add(new SqlMonikerImpl(child.name, SqlMonikerType.TABLE));
        }
        this.parent.findAliases(result);
    }

    @Override
    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String columnName, SqlNode ctx) {
        SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
        Map<String, ScopeChild> map = this.findQualifyingTableNames(columnName, ctx, nameMatcher);
        switch (map.size()) {
            case 0: {
                throw this.validator.newValidationError(ctx, Static.RESOURCE.columnNotFound(columnName));
            }
            case 1: {
                Map.Entry<String, ScopeChild> entry = map.entrySet().iterator().next();
                return Pair.of(entry.getKey(), entry.getValue().namespace);
            }
        }
        throw this.validator.newValidationError(ctx, Static.RESOURCE.columnAmbiguous(columnName));
    }

    @Override
    public Map<String, ScopeChild> findQualifyingTableNames(String columnName, SqlNode ctx, SqlNameMatcher nameMatcher) {
        HashMap<String, ScopeChild> map = new HashMap<String, ScopeChild>();
        for (ScopeChild child : this.children) {
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            this.resolve((List<String>)ImmutableList.of((Object)child.name, (Object)columnName), nameMatcher, true, resolved);
            if (resolved.count() <= 0) continue;
            map.put(child.name, child);
        }
        switch (map.size()) {
            case 0: {
                return this.parent.findQualifyingTableNames(columnName, ctx, nameMatcher);
            }
        }
        return map;
    }

    @Override
    public void resolve(List<String> names, SqlNameMatcher nameMatcher, boolean deep, SqlValidatorScope.Resolved resolved) {
        ScopeChild child0 = this.findChild(names, nameMatcher);
        if (child0 != null) {
            SqlValidatorScope.Step path = SqlValidatorScope.Path.EMPTY.plus(child0.namespace.getRowType(), child0.ordinal, child0.name, StructKind.FULLY_QUALIFIED);
            resolved.found(child0.namespace, child0.nullable, this, path, null);
            return;
        }
        if (deep) {
            for (ScopeChild child : this.children) {
                List<String> names2 = nameMatcher.matches(child.name, names.get(0)) ? names.subList(1, names.size()) : names;
                this.resolveInNamespace(child.namespace, child.nullable, names2, nameMatcher, SqlValidatorScope.Path.EMPTY, resolved);
            }
            if (resolved.count() > 0) {
                return;
            }
        }
        super.resolve(names, nameMatcher, deep, resolved);
    }

    @Override
    public RelDataType resolveColumn(String columnName, SqlNode ctx) {
        SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
        int found = 0;
        RelDataType type = null;
        for (ScopeChild child : this.children) {
            SqlValidatorNamespace childNs = child.namespace;
            RelDataType childRowType = childNs.getRowType();
            RelDataTypeField field = nameMatcher.field(childRowType, columnName);
            if (field == null) continue;
            ++found;
            type = field.getType();
        }
        switch (found) {
            case 0: {
                return null;
            }
            case 1: {
                return type;
            }
        }
        throw this.validator.newValidationError(ctx, Static.RESOURCE.columnAmbiguous(columnName));
    }
}

