/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.materialize.Lattice;
import org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

class CachingLatticeStatisticProvider
implements LatticeStatisticProvider {
    private final LoadingCache<Pair<Lattice, Lattice.Column>, Integer> cache;

    CachingLatticeStatisticProvider(final LatticeStatisticProvider provider) {
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<Lattice, Lattice.Column>, Integer>(){

            public Integer load(Pair<Lattice, Lattice.Column> key) throws Exception {
                return provider.cardinality((Lattice)key.left, (Lattice.Column)key.right);
            }
        });
    }

    @Override
    public int cardinality(Lattice lattice, Lattice.Column column) {
        try {
            return (Integer)this.cache.get(Pair.of(lattice, column));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Util.throwIfUnchecked(e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

