---
version: '0.12'
order: 12
layout: page
menu_title: 0.12
title: Apache Samza 0.12
---
<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->

We are excited to announce that the **Apache Samza 0.12.0** has been released. It is a major release with several features; notably batch processing and enhancements to improve stability, performance and ease of use. 

####Enhancements and Bug Fixes
Overall, [30 JIRAs](https://issues.apache.org/jira/browse/SAMZA-469?jql=project%20%3D%2012314526%20AND%20fixVersion%20%3D%200.12.0%20%20AND%20status%20%3D%20Resolved%20%20ORDER%20BY%20priority%20DESC%2C%20key%20ASC) were resolve in this release. Here are few highlights

- [SAMZA-967](https://issues.apache.org/jira/browse/SAMZA-967) Add HDFS system consumer
- [SAMZA-1042](https://issues.apache.org/jira/browse/SAMZA-1042) Allow offset notifications for input systems
- [SAMZA-1013](https://issues.apache.org/jira/browse/SAMZA-1013) Support YARN node labels
- [SAMZA-1079](https://issues.apache.org/jira/browse/SAMZA-1079) Add timeout for blocking reads when localizing containers
- [SAMZA-1077](https://issues.apache.org/jira/browse/SAMZA-1077) Handle all exceptions and errors in container
- [SAMZA-1069](https://issues.apache.org/jira/browse/SAMZA-1069) Deadlock between kafka system producer and kafka producer from kafka-clients lib
- [SAMZA-1065](https://issues.apache.org/jira/browse/SAMZA-1065) Handle commit order correctly to guarantee at least once processing when using local store for dedup

####Upgrade Notes
- Upgraded Kafka version to 0.10. This enables us to take advantage of the critical fixes and improvements in Kafka.
- Upgraded to Jetty 9 from Jetty 8.
- Full support for Scala 2.11. All Samza jars will now have the scala version as 2.11 as a part of their file name. For example, samza-yarn_2.11-0.12.jar.
- Samza is now source compatible with JDK 8 and above. Older JDKs are no longer supported.

####Sources and Artifacts
[Samza-sources-0.12.0.tgz](http://www.apache.org/dyn/closer.cgi/samza/0.12.0)

For more details about this release, please check out the [release blog post](https://blogs.apache.org/samza/).
