package org.apache.rya.indexing.pcj.fluo.app.export;
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import org.apache.rya.api.domain.RyaSubGraph;
import org.apache.rya.indexing.pcj.fluo.app.export.IncrementalBindingSetExporter.ResultExportException;

/**
 * Incrementally exports {@link RyaSubGraph}s that are generated by SPARQL Construct Queries
 * from the Rya-Fluo application to the core Rya tables.
 *
 */
public interface IncrementalRyaSubGraphExporter extends IncrementalResultExporter {

    /**
     * Export a RyaSubGraph that is the result of SPARQL Construct Query.
     *
     * @param constructID - The Fluo Id of the construct query the created the RyaSubGraph
     * @param subgraph - The RyaSubGraph to export (non-null)
     * @throws ResultExportException The result could not be exported.
     */
    public void export(String constructID, RyaSubGraph subgraph) throws ResultExportException;
    
}
