/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.rya.rdftriplestore.inference;

import org.openrdf.model.URI;

public class InverseURI implements URI {
    private static final long serialVersionUID = 1L;

    private final URI impl;

    public InverseURI(final URI uri) {
        this.impl = uri;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((impl == null) ? 0 : impl.hashCode());
        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj instanceof InverseURI){
            return impl.equals(((InverseURI) obj).impl);
        }
        return false;
    }

    @Override
    public String stringValue() {
        return impl.stringValue();
    }

    @Override
    public String getNamespace() {
        return impl.getNamespace();
    }

    @Override
    public String getLocalName() {
        return impl.getLocalName();
    }


}
