
<!--

[comment]: # Licensed to the Apache Software Foundation (ASF) under one
[comment]: # or more contributor license agreements.  See the NOTICE file
[comment]: # distributed with this work for additional information
[comment]: # regarding copyright ownership.  The ASF licenses this file
[comment]: # to you under the Apache License, Version 2.0 (the
[comment]: # "License"); you may not use this file except in compliance
[comment]: # with the License.  You may obtain a copy of the License at
[comment]: # 
[comment]: #   http://www.apache.org/licenses/LICENSE-2.0
[comment]: # 
[comment]: # Unless required by applicable law or agreed to in writing,
[comment]: # software distributed under the License is distributed on an
[comment]: # "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
[comment]: # KIND, either express or implied.  See the License for the
[comment]: # specific language governing permissions and limitations
[comment]: # under the License.

-->

# Apache Rya

This project contains documentation about Apache Rya, a scalable RDF triple store on top of Accumulo.

- [Overview](overview.md)
- [Quick Start](quickstart.md)
- [Load Data](loaddata.md)
- [Query Data](querydata.md)
- [Evaluation Table](eval.md)
- [Pre-computed Joins](loadPrecomputedJoin.md)
- [Inferencing](infer.md)
- [MapReduce Interface](mapreduce.md)
- [Shell Interface](shell.md)
- [Incremental Join Maintenance Application (PCJ Updater)](pcj-updater.md)

# Samples
- [Typical First Steps](sm-firststeps.md)
- [Simple Add/Query/Remove Statements](sm-simpleaqr.md)
- [Sparql query](sm-sparqlquery.md)
- [Adding Authentication](sm-addauth.md)
- [Inferencing](sm-infer.md)
- [Named Graph](sm-namedgraph.md)
- [Update data](sm-updatedata.md)
- [Alx](alx.md)

# Development
- [Building From Source](build-source.md)
