/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.rya.api.domain;

import org.junit.Assert;
import org.junit.Test;
import org.openrdf.model.impl.URIImpl;

public class StatementMetadataTest {

    @Test
    public void simpleTests() throws Exception {
        StatementMetadata empty = new StatementMetadata();
        byte[] emptyData = empty.toBytes();
        Assert.assertArrayEquals(emptyData, new StatementMetadata(emptyData).toBytes());

        
        StatementMetadata single = new StatementMetadata();
        single.addMetadata(new RyaURI("http://uri"), new RyaType("http://type"));
        byte[] singleData = single.toBytes();
        Assert.assertArrayEquals(singleData, new StatementMetadata(singleData).toBytes());

    }
}
