/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.ant.config;

import org.apache.royale.compiler.ant.FlexTask;
import org.apache.royale.compiler.ant.config.IOptionSource;
import org.apache.royale.compiler.ant.config.OptionSpec;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.types.Commandline;

public class NestedAttributeElement
implements DynamicAttribute,
IOptionSource {
    private static final String COMMA = ",";
    private String[] attribs;
    private String[] values;
    protected OptionSpec spec;
    private boolean valueHasComma;
    private FlexTask task;
    private boolean isAppend;
    private final boolean allowAppendAttribute;

    public NestedAttributeElement(String attrib, OptionSpec spec) {
        this(new String[]{attrib}, spec, null);
    }

    public NestedAttributeElement(String[] attribs, OptionSpec spec) {
        this(attribs, spec, null);
    }

    public NestedAttributeElement(String attrib, OptionSpec spec, FlexTask task) {
        this(new String[]{attrib}, spec, task);
    }

    public NestedAttributeElement(String[] attribs, OptionSpec spec, FlexTask task) {
        this(attribs, spec, task, false);
    }

    public NestedAttributeElement(String[] attribs, OptionSpec spec, FlexTask task, boolean allowAppend) {
        this.attribs = attribs;
        this.values = new String[attribs.length];
        this.spec = spec;
        this.task = task;
        this.allowAppendAttribute = allowAppend;
        this.isAppend = false;
    }

    public void addText(String value) {
        if (this.task != null) {
            value = this.task.getProject().replaceProperties(value);
        }
        this.values[0] = value;
        if (value.indexOf(COMMA) != -1) {
            this.valueHasComma = true;
        }
    }

    public void setDynamicAttribute(String name, String value) {
        if (this.allowAppendAttribute && name.equals("append")) {
            this.isAppend = Boolean.parseBoolean(value);
            return;
        }
        boolean isSet = false;
        for (int i = 0; i < this.attribs.length && !isSet; ++i) {
            if (!this.attribs[i].equals(name)) continue;
            this.values[i] = value;
            isSet = true;
        }
        if (value.indexOf(COMMA) != -1) {
            this.valueHasComma = true;
        }
        if (!isSet) {
            throw new BuildException("The <" + this.spec.getFullName() + "> type doesn't support the \"" + name + "\" attribute.");
        }
    }

    @Override
    public void addToCommandline(Commandline cmdline) {
        if (this.valueHasComma) {
            cmdline.createArgument().setValue("-" + this.spec.getFullName());
            for (int i = 0; i < this.attribs.length; ++i) {
                if (this.values[i] == null) continue;
                cmdline.createArgument().setValue(this.values[i].replaceAll("\\s*,\\s*", COMMA));
            }
        } else {
            StringBuilder stringBuffer = new StringBuilder();
            for (int i = 0; i < this.attribs.length; ++i) {
                if (this.values[i] == null) continue;
                stringBuffer.append(this.values[i]);
                if (i + 1 >= this.attribs.length) continue;
                stringBuffer.append(COMMA);
            }
            String cmdLineArgument = String.format("-%s%s=%s", this.spec.getFullName(), this.isAppend ? "+" : "", stringBuffer);
            cmdline.createArgument().setValue(cmdLineArgument);
        }
    }
}

